/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ServerLoginPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.ICustomPacket;
import net.minecraftforge.network.LoginWrapper;
import org.jetbrains.annotations.Nullable;

public class ServerboundCustomQueryPacket
implements Packet<ServerLoginPacketListener>,
ICustomPacket<ServerboundCustomQueryPacket> {
    private static final int MAX_PAYLOAD_SIZE = 0x100000;
    private final int transactionId;
    @javax.annotation.Nullable
    private final FriendlyByteBuf data;

    public ServerboundCustomQueryPacket(int p_134829_, @javax.annotation.Nullable FriendlyByteBuf p_134830_) {
        this.transactionId = p_134829_;
        this.data = p_134830_;
    }

    public ServerboundCustomQueryPacket(FriendlyByteBuf p_179823_) {
        this.transactionId = p_179823_.readVarInt();
        this.data = (FriendlyByteBuf)p_179823_.readNullable(p_238039_ -> {
            int i = p_238039_.readableBytes();
            if (i >= 0 && i <= 0x100000) {
                return new FriendlyByteBuf(p_238039_.readBytes(i));
            }
            throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
        });
    }

    @Override
    public void write(FriendlyByteBuf p_134838_) {
        p_134838_.writeVarInt(this.transactionId);
        p_134838_.writeNullable(this.data, (p_238036_, p_238037_) -> p_238036_.writeBytes(p_238037_.slice()));
    }

    @Override
    public void handle(ServerLoginPacketListener p_134836_) {
        p_134836_.handleCustomQueryPacket(this);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    @javax.annotation.Nullable
    public FriendlyByteBuf getData() {
        return this.data;
    }

    @Override
    public int getIndex() {
        return this.getTransactionId();
    }

    @Override
    public ResourceLocation getName() {
        return LoginWrapper.WRAPPER;
    }

    @Override
    @Nullable
    public FriendlyByteBuf getInternalData() {
        return this.getData();
    }
}

