/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class SetBlockCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.setblock.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> p_214731_, CommandBuildContext p_214732_) {
        p_214731_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("setblock").requires(p_138606_ -> p_138606_.hasPermission(2))).then(Commands.argument("pos", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("block", BlockStateArgument.block(p_214732_)).executes(p_138618_ -> SetBlockCommand.setBlock((CommandSourceStack)p_138618_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_138618_, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_138618_, "block"), Mode.REPLACE, null))).then(Commands.literal("destroy").executes(p_138616_ -> SetBlockCommand.setBlock((CommandSourceStack)p_138616_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_138616_, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_138616_, "block"), Mode.DESTROY, null)))).then(Commands.literal("keep").executes(p_138614_ -> SetBlockCommand.setBlock((CommandSourceStack)p_138614_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_138614_, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_138614_, "block"), Mode.REPLACE, p_180517_ -> p_180517_.getLevel().isEmptyBlock(p_180517_.getPos()))))).then(Commands.literal("replace").executes(p_138604_ -> SetBlockCommand.setBlock((CommandSourceStack)p_138604_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_138604_, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_138604_, "block"), Mode.REPLACE, null))))));
    }

    private static int setBlock(CommandSourceStack p_138608_, BlockPos p_138609_, BlockInput p_138610_, Mode p_138611_, @Nullable Predicate<BlockInWorld> p_138612_) throws CommandSyntaxException {
        boolean flag;
        ServerLevel serverlevel = p_138608_.getLevel();
        if (p_138612_ != null && !p_138612_.test(new BlockInWorld(serverlevel, p_138609_, true))) {
            throw ERROR_FAILED.create();
        }
        if (p_138611_ == Mode.DESTROY) {
            serverlevel.destroyBlock(p_138609_, true);
            flag = !p_138610_.getState().isAir() || !serverlevel.getBlockState(p_138609_).isAir();
        } else {
            BlockEntity blockentity = serverlevel.getBlockEntity(p_138609_);
            Clearable.tryClear(blockentity);
            flag = true;
        }
        if (flag && !p_138610_.place(serverlevel, p_138609_, 2)) {
            throw ERROR_FAILED.create();
        }
        serverlevel.blockUpdated(p_138609_, p_138610_.getState().getBlock());
        p_138608_.sendSuccess(() -> Component.translatable("commands.setblock.success", p_138609_.getX(), p_138609_.getY(), p_138609_.getZ()), true);
        return 1;
    }

    public static enum Mode {
        REPLACE,
        DESTROY;

    }

    public static interface Filter {
        @Nullable
        public BlockInput filter(BoundingBox var1, BlockPos var2, BlockInput var3, ServerLevel var4);
    }
}

