/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.Level;

public class SpawnArmorTrimsCommand {
    private static final Map<Pair<ArmorMaterial, EquipmentSlot>, Item> MATERIAL_AND_SLOT_TO_ITEM = Util.make(Maps.newHashMap(), p_266706_ -> {
        p_266706_.put(Pair.of((Object)ArmorMaterials.CHAIN, (Object)((Object)EquipmentSlot.HEAD)), Items.CHAINMAIL_HELMET);
        p_266706_.put(Pair.of((Object)ArmorMaterials.CHAIN, (Object)((Object)EquipmentSlot.CHEST)), Items.CHAINMAIL_CHESTPLATE);
        p_266706_.put(Pair.of((Object)ArmorMaterials.CHAIN, (Object)((Object)EquipmentSlot.LEGS)), Items.CHAINMAIL_LEGGINGS);
        p_266706_.put(Pair.of((Object)ArmorMaterials.CHAIN, (Object)((Object)EquipmentSlot.FEET)), Items.CHAINMAIL_BOOTS);
        p_266706_.put(Pair.of((Object)ArmorMaterials.IRON, (Object)((Object)EquipmentSlot.HEAD)), Items.IRON_HELMET);
        p_266706_.put(Pair.of((Object)ArmorMaterials.IRON, (Object)((Object)EquipmentSlot.CHEST)), Items.IRON_CHESTPLATE);
        p_266706_.put(Pair.of((Object)ArmorMaterials.IRON, (Object)((Object)EquipmentSlot.LEGS)), Items.IRON_LEGGINGS);
        p_266706_.put(Pair.of((Object)ArmorMaterials.IRON, (Object)((Object)EquipmentSlot.FEET)), Items.IRON_BOOTS);
        p_266706_.put(Pair.of((Object)ArmorMaterials.GOLD, (Object)((Object)EquipmentSlot.HEAD)), Items.GOLDEN_HELMET);
        p_266706_.put(Pair.of((Object)ArmorMaterials.GOLD, (Object)((Object)EquipmentSlot.CHEST)), Items.GOLDEN_CHESTPLATE);
        p_266706_.put(Pair.of((Object)ArmorMaterials.GOLD, (Object)((Object)EquipmentSlot.LEGS)), Items.GOLDEN_LEGGINGS);
        p_266706_.put(Pair.of((Object)ArmorMaterials.GOLD, (Object)((Object)EquipmentSlot.FEET)), Items.GOLDEN_BOOTS);
        p_266706_.put(Pair.of((Object)ArmorMaterials.NETHERITE, (Object)((Object)EquipmentSlot.HEAD)), Items.NETHERITE_HELMET);
        p_266706_.put(Pair.of((Object)ArmorMaterials.NETHERITE, (Object)((Object)EquipmentSlot.CHEST)), Items.NETHERITE_CHESTPLATE);
        p_266706_.put(Pair.of((Object)ArmorMaterials.NETHERITE, (Object)((Object)EquipmentSlot.LEGS)), Items.NETHERITE_LEGGINGS);
        p_266706_.put(Pair.of((Object)ArmorMaterials.NETHERITE, (Object)((Object)EquipmentSlot.FEET)), Items.NETHERITE_BOOTS);
        p_266706_.put(Pair.of((Object)ArmorMaterials.DIAMOND, (Object)((Object)EquipmentSlot.HEAD)), Items.DIAMOND_HELMET);
        p_266706_.put(Pair.of((Object)ArmorMaterials.DIAMOND, (Object)((Object)EquipmentSlot.CHEST)), Items.DIAMOND_CHESTPLATE);
        p_266706_.put(Pair.of((Object)ArmorMaterials.DIAMOND, (Object)((Object)EquipmentSlot.LEGS)), Items.DIAMOND_LEGGINGS);
        p_266706_.put(Pair.of((Object)ArmorMaterials.DIAMOND, (Object)((Object)EquipmentSlot.FEET)), Items.DIAMOND_BOOTS);
        p_266706_.put(Pair.of((Object)ArmorMaterials.TURTLE, (Object)((Object)EquipmentSlot.HEAD)), Items.TURTLE_HELMET);
    });
    private static final List<ResourceKey<TrimPattern>> VANILLA_TRIM_PATTERNS = List.of(TrimPatterns.SENTRY, TrimPatterns.DUNE, TrimPatterns.COAST, TrimPatterns.WILD, TrimPatterns.WARD, TrimPatterns.EYE, TrimPatterns.VEX, TrimPatterns.TIDE, TrimPatterns.SNOUT, TrimPatterns.RIB, TrimPatterns.SPIRE, TrimPatterns.WAYFINDER, TrimPatterns.SHAPER, TrimPatterns.SILENCE, TrimPatterns.RAISER, TrimPatterns.HOST);
    private static final List<ResourceKey<TrimMaterial>> VANILLA_TRIM_MATERIALS = List.of(TrimMaterials.QUARTZ, TrimMaterials.IRON, TrimMaterials.NETHERITE, TrimMaterials.REDSTONE, TrimMaterials.COPPER, TrimMaterials.GOLD, TrimMaterials.EMERALD, TrimMaterials.DIAMOND, TrimMaterials.LAPIS, TrimMaterials.AMETHYST);
    private static final ToIntFunction<ResourceKey<TrimPattern>> TRIM_PATTERN_ORDER = Util.createIndexLookup(VANILLA_TRIM_PATTERNS);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> TRIM_MATERIAL_ORDER = Util.createIndexLookup(VANILLA_TRIM_MATERIALS);

    public static void register(CommandDispatcher<CommandSourceStack> p_266758_) {
        p_266758_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("spawn_armor_trims").requires(p_277270_ -> p_277270_.hasPermission(2))).executes(p_267005_ -> SpawnArmorTrimsCommand.spawnArmorTrims((CommandSourceStack)p_267005_.getSource(), ((CommandSourceStack)p_267005_.getSource()).getPlayerOrException())));
    }

    private static int spawnArmorTrims(CommandSourceStack p_266993_, Player p_266983_) {
        Level level = p_266983_.level();
        NonNullList<ArmorTrim> nonnulllist = NonNullList.create();
        Registry<TrimPattern> registry = level.registryAccess().registryOrThrow(Registries.TRIM_PATTERN);
        Registry<TrimMaterial> registry1 = level.registryAccess().registryOrThrow(Registries.TRIM_MATERIAL);
        registry.stream().sorted(Comparator.comparing(p_266941_ -> TRIM_PATTERN_ORDER.applyAsInt(registry.getResourceKey((TrimPattern)p_266941_).orElse(null)))).forEachOrdered(p_266759_ -> registry1.stream().sorted(Comparator.comparing(p_267239_ -> TRIM_MATERIAL_ORDER.applyAsInt(registry1.getResourceKey((TrimMaterial)p_267239_).orElse(null)))).forEachOrdered(p_267162_ -> nonnulllist.add(new ArmorTrim(registry1.wrapAsHolder((TrimMaterial)p_267162_), registry.wrapAsHolder((TrimPattern)p_266759_)))));
        BlockPos blockpos = p_266983_.blockPosition().relative(p_266983_.getDirection(), 5);
        int i = ArmorMaterials.values().length - 1;
        double d0 = 3.0;
        int j = 0;
        int k = 0;
        for (ArmorTrim armortrim : nonnulllist) {
            for (ArmorMaterials armormaterial : ArmorMaterials.values()) {
                if (armormaterial == ArmorMaterials.LEATHER) continue;
                double d1 = (double)blockpos.getX() + 0.5 - (double)(j % registry1.size()) * 3.0;
                double d2 = (double)blockpos.getY() + 0.5 + (double)(k % i) * 3.0;
                double d3 = (double)blockpos.getZ() + 0.5 + (double)(j / registry1.size() * 10);
                ArmorStand armorstand = new ArmorStand(level, d1, d2, d3);
                armorstand.setYRot(180.0f);
                armorstand.setNoGravity(true);
                for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                    ArmorItem armoritem;
                    Item item = MATERIAL_AND_SLOT_TO_ITEM.get(Pair.of((Object)armormaterial, (Object)((Object)equipmentslot)));
                    if (item == null) continue;
                    ItemStack itemstack = new ItemStack(item);
                    ArmorTrim.setTrim(level.registryAccess(), itemstack, armortrim);
                    armorstand.setItemSlot(equipmentslot, itemstack);
                    if (item instanceof ArmorItem && (armoritem = (ArmorItem)item).getMaterial() == ArmorMaterials.TURTLE) {
                        armorstand.setCustomName(armortrim.pattern().value().copyWithStyle(armortrim.material()).copy().append(" ").append(armortrim.material().value().description()));
                        armorstand.setCustomNameVisible(true);
                        continue;
                    }
                    armorstand.setInvisible(true);
                }
                level.addFreshEntity(armorstand);
                ++k;
            }
            ++j;
        }
        p_266993_.sendSuccess(() -> Component.literal("Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }
}

