/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.primitives.Ints;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.logging.LogUtils;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.login.ClientboundGameProfilePacket;
import net.minecraft.network.protocol.login.ClientboundHelloPacket;
import net.minecraft.network.protocol.login.ClientboundLoginCompressionPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.ServerLoginPacketListener;
import net.minecraft.network.protocol.login.ServerboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.network.protocol.login.ServerboundKeyPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.util.RandomSource;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.DualStackUtils;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class ServerLoginPacketListenerImpl
implements ServerLoginPacketListener,
TickablePacketListener {
    private static final AtomicInteger UNIQUE_THREAD_ID = new AtomicInteger(0);
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TICKS_BEFORE_LOGIN = 600;
    private static final RandomSource RANDOM = RandomSource.create();
    private final byte[] challenge;
    final MinecraftServer server;
    final Connection connection;
    State state = State.HELLO;
    private int tick;
    @Nullable
    public GameProfile gameProfile;
    private final String serverId = "";
    @Nullable
    private ServerPlayer delayedAcceptPlayer;

    public ServerLoginPacketListenerImpl(MinecraftServer p_10027_, Connection p_10028_) {
        this.server = p_10027_;
        this.connection = p_10028_;
        this.challenge = Ints.toByteArray((int)RANDOM.nextInt());
    }

    @Override
    public void tick() {
        ServerPlayer serverplayer;
        if (this.state == State.NEGOTIATING) {
            boolean negotiationComplete = NetworkHooks.tickNegotiation(this, this.connection, this.delayedAcceptPlayer);
            if (negotiationComplete) {
                this.state = State.READY_TO_ACCEPT;
            }
        } else if (this.state == State.READY_TO_ACCEPT) {
            this.handleAcceptedLogin();
        } else if (this.state == State.DELAY_ACCEPT && (serverplayer = this.server.getPlayerList().getPlayer(this.gameProfile.getId())) == null) {
            this.state = State.READY_TO_ACCEPT;
            this.placeNewPlayer(this.delayedAcceptPlayer);
            this.delayedAcceptPlayer = null;
        }
        if (this.tick++ == 600) {
            this.disconnect(Component.translatable("multiplayer.disconnect.slow_login"));
        }
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }

    public void disconnect(Component p_10054_) {
        try {
            LOGGER.info("Disconnecting {}: {}", (Object)this.getUserName(), (Object)p_10054_.getString());
            this.connection.send(new ClientboundLoginDisconnectPacket(p_10054_));
            this.connection.disconnect(p_10054_);
        }
        catch (Exception exception) {
            LOGGER.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    public void handleAcceptedLogin() {
        Component component;
        if (!this.gameProfile.isComplete()) {
            this.gameProfile = this.createFakeProfile(this.gameProfile);
        }
        if ((component = this.server.getPlayerList().canPlayerLogin(this.connection.getRemoteAddress(), this.gameProfile)) != null) {
            this.disconnect(component);
        } else {
            this.state = State.ACCEPTED;
            if (this.server.getCompressionThreshold() >= 0 && !this.connection.isMemoryConnection()) {
                this.connection.send(new ClientboundLoginCompressionPacket(this.server.getCompressionThreshold()), PacketSendListener.thenRun(() -> this.connection.setupCompression(this.server.getCompressionThreshold(), true)));
            }
            this.connection.send(new ClientboundGameProfilePacket(this.gameProfile));
            ServerPlayer serverplayer = this.server.getPlayerList().getPlayer(this.gameProfile.getId());
            try {
                ServerPlayer serverplayer1 = this.server.getPlayerList().getPlayerForLogin(this.gameProfile);
                if (serverplayer != null) {
                    this.state = State.DELAY_ACCEPT;
                    this.delayedAcceptPlayer = serverplayer1;
                } else {
                    this.placeNewPlayer(serverplayer1);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't place player in world", (Throwable)exception);
                MutableComponent component1 = Component.translatable("multiplayer.disconnect.invalid_player_data");
                this.connection.send(new ClientboundDisconnectPacket(component1));
                this.connection.disconnect(component1);
            }
        }
    }

    private void placeNewPlayer(ServerPlayer p_143700_) {
        this.server.getPlayerList().placeNewPlayer(this.connection, p_143700_);
    }

    @Override
    public void onDisconnect(Component p_10043_) {
        LOGGER.info("{} lost connection: {}", (Object)this.getUserName(), (Object)p_10043_.getString());
    }

    public String getUserName() {
        String addressString = DualStackUtils.getAddressString(this.connection.getRemoteAddress());
        return this.gameProfile != null ? String.valueOf(this.gameProfile) + " (" + addressString + ")" : addressString;
    }

    @Override
    public void handleHello(ServerboundHelloPacket p_10047_) {
        Validate.validState((this.state == State.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        Validate.validState((boolean)ServerLoginPacketListenerImpl.isValidUsername(p_10047_.name()), (String)"Invalid characters in username", (Object[])new Object[0]);
        GameProfile gameprofile = this.server.getSingleplayerProfile();
        if (gameprofile != null && p_10047_.name().equalsIgnoreCase(gameprofile.getName())) {
            this.gameProfile = gameprofile;
            this.state = State.NEGOTIATING;
        } else {
            this.gameProfile = new GameProfile((UUID)null, p_10047_.name());
            if (this.server.usesAuthentication() && !this.connection.isMemoryConnection()) {
                this.state = State.KEY;
                this.connection.send(new ClientboundHelloPacket("", this.server.getKeyPair().getPublic().getEncoded(), this.challenge));
            } else {
                this.state = State.NEGOTIATING;
            }
        }
    }

    public static boolean isValidUsername(String p_203793_) {
        return p_203793_.chars().filter(p_203791_ -> p_203791_ <= 32 || p_203791_ >= 127).findAny().isEmpty();
    }

    @Override
    public void handleKey(ServerboundKeyPacket p_10049_) {
        String s;
        Validate.validState((this.state == State.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey privatekey = this.server.getKeyPair().getPrivate();
            if (!p_10049_.isChallengeValid(this.challenge, privatekey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretkey = p_10049_.getSecretKey(privatekey);
            Cipher cipher = Crypt.getCipher(2, secretkey);
            Cipher cipher1 = Crypt.getCipher(1, secretkey);
            s = new BigInteger(Crypt.digestData("", this.server.getKeyPair().getPublic(), secretkey)).toString(16);
            this.state = State.AUTHENTICATING;
            this.connection.setEncryptionKey(cipher, cipher1);
        }
        catch (CryptException cryptexception) {
            throw new IllegalStateException("Protocol error", cryptexception);
        }
        Thread thread = new Thread((ThreadGroup)SidedThreadGroups.SERVER, "User Authenticator #" + UNIQUE_THREAD_ID.incrementAndGet()){

            @Override
            public void run() {
                GameProfile gameprofile = ServerLoginPacketListenerImpl.this.gameProfile;
                try {
                    ServerLoginPacketListenerImpl.this.gameProfile = ServerLoginPacketListenerImpl.this.server.getSessionService().hasJoinedServer(new GameProfile((UUID)null, gameprofile.getName()), s, this.getAddress());
                    if (ServerLoginPacketListenerImpl.this.gameProfile != null) {
                        LOGGER.info("UUID of player {} is {}", (Object)ServerLoginPacketListenerImpl.this.gameProfile.getName(), (Object)ServerLoginPacketListenerImpl.this.gameProfile.getId());
                        ServerLoginPacketListenerImpl.this.state = State.NEGOTIATING;
                    } else if (ServerLoginPacketListenerImpl.this.server.isSingleplayer()) {
                        LOGGER.warn("Failed to verify username but will let them in anyway!");
                        ServerLoginPacketListenerImpl.this.gameProfile = gameprofile;
                        ServerLoginPacketListenerImpl.this.state = State.NEGOTIATING;
                    } else {
                        ServerLoginPacketListenerImpl.this.disconnect(Component.translatable("multiplayer.disconnect.unverified_username"));
                        LOGGER.error("Username '{}' tried to join with an invalid session", (Object)gameprofile.getName());
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (ServerLoginPacketListenerImpl.this.server.isSingleplayer()) {
                        LOGGER.warn("Authentication servers are down but will let them in anyway!");
                        ServerLoginPacketListenerImpl.this.gameProfile = gameprofile;
                        ServerLoginPacketListenerImpl.this.state = State.NEGOTIATING;
                    }
                    ServerLoginPacketListenerImpl.this.disconnect(Component.translatable("multiplayer.disconnect.authservers_down"));
                    LOGGER.error("Couldn't verify username because servers are unavailable");
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress socketaddress = ServerLoginPacketListenerImpl.this.connection.getRemoteAddress();
                return ServerLoginPacketListenerImpl.this.server.getPreventProxyConnections() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        };
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        thread.start();
    }

    @Override
    public void handleCustomQueryPacket(ServerboundCustomQueryPacket p_10045_) {
        if (!NetworkHooks.onCustomPayload(p_10045_, this.connection)) {
            this.disconnect(Component.translatable("multiplayer.disconnect.unexpected_query_response"));
        }
    }

    protected GameProfile createFakeProfile(GameProfile p_10039_) {
        UUID uuid = UUIDUtil.createOfflinePlayerUUID(p_10039_.getName());
        return new GameProfile(uuid, p_10039_.getName());
    }

    static enum State {
        HELLO,
        KEY,
        AUTHENTICATING,
        NEGOTIATING,
        READY_TO_ACCEPT,
        DELAY_ACCEPT,
        ACCEPTED;

    }
}

