/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlagSet;
import org.slf4j.Logger;

public class Pack {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String id;
    private final ResourcesSupplier resources;
    private final Component title;
    private final Component description;
    private final PackCompatibility compatibility;
    private final FeatureFlagSet requestedFeatures;
    private final Position defaultPosition;
    private final boolean required;
    private final boolean fixedPosition;
    private final boolean hidden;
    private final PackSource packSource;

    @Nullable
    public static Pack readMetaAndCreate(String p_249649_, Component p_248632_, boolean p_251594_, ResourcesSupplier p_252210_, PackType p_250595_, Position p_248706_, PackSource p_251233_) {
        Info pack$info = Pack.readPackInfo(p_249649_, p_252210_);
        return pack$info != null ? Pack.create(p_249649_, p_248632_, p_251594_, p_252210_, pack$info, p_250595_, p_248706_, false, p_251233_) : null;
    }

    public static Pack create(String p_252257_, Component p_248717_, boolean p_248811_, ResourcesSupplier p_248969_, Info p_251314_, PackType p_250264_, Position p_252110_, boolean p_250237_, PackSource p_248524_) {
        return new Pack(p_252257_, p_248811_, p_248969_, p_248717_, p_251314_, p_251314_.compatibility(p_250264_), p_252110_, p_250237_, p_248524_);
    }

    private Pack(String p_252218_, boolean p_248829_, ResourcesSupplier p_249377_, Component p_251718_, Info p_250162_, PackCompatibility p_250361_, Position p_251298_, boolean p_249753_, PackSource p_251608_) {
        this.id = p_252218_;
        this.resources = p_249377_;
        this.title = p_251718_;
        this.description = p_250162_.description();
        this.compatibility = p_250361_;
        this.requestedFeatures = p_250162_.requestedFeatures();
        this.required = p_248829_;
        this.defaultPosition = p_251298_;
        this.fixedPosition = p_249753_;
        this.packSource = p_251608_;
        this.hidden = p_250162_.hidden();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Info readPackInfo(String p_250591_, ResourcesSupplier p_250739_) {
        try (PackResources packresources = p_250739_.open(p_250591_);){
            PackMetadataSection packmetadatasection = packresources.getMetadataSection(PackMetadataSection.TYPE);
            if (packmetadatasection == null) {
                LOGGER.warn("Missing metadata in pack {}", (Object)p_250591_);
                Info info = null;
                return info;
            }
            FeatureFlagsMetadataSection featureflagsmetadatasection = packresources.getMetadataSection(FeatureFlagsMetadataSection.TYPE);
            FeatureFlagSet featureflagset = featureflagsmetadatasection != null ? featureflagsmetadatasection.flags() : FeatureFlagSet.of();
            Info info = new Info(packmetadatasection.getDescription(), packmetadatasection.getPackFormat(PackType.SERVER_DATA), packmetadatasection.getPackFormat(PackType.CLIENT_RESOURCES), featureflagset, packresources.isHidden());
            return info;
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to read pack metadata", (Throwable)exception);
            return null;
        }
    }

    public Component getTitle() {
        return this.title;
    }

    public Component getDescription() {
        return this.description;
    }

    public Component getChatLink(boolean p_10438_) {
        return ComponentUtils.wrapInSquareBrackets(this.packSource.decorate(Component.literal(this.id))).withStyle(p_10441_ -> p_10441_.withColor(p_10438_ ? ChatFormatting.GREEN : ChatFormatting.RED).withInsertion(StringArgumentType.escapeIfRequired((String)this.id)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, Component.empty().append(this.title).append("\n").append(this.description))));
    }

    public PackCompatibility getCompatibility() {
        return this.compatibility;
    }

    public FeatureFlagSet getRequestedFeatures() {
        return this.requestedFeatures;
    }

    public PackResources open() {
        return this.resources.open(this.id);
    }

    public String getId() {
        return this.id;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isFixedPosition() {
        return this.fixedPosition;
    }

    public Position getDefaultPosition() {
        return this.defaultPosition;
    }

    public PackSource getPackSource() {
        return this.packSource;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean equals(Object p_10448_) {
        if (this == p_10448_) {
            return true;
        }
        if (!(p_10448_ instanceof Pack)) {
            return false;
        }
        Pack pack = (Pack)p_10448_;
        return this.id.equals(pack.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @FunctionalInterface
    public static interface ResourcesSupplier {
        public PackResources open(String var1);
    }

    public record Info(Component description, int dataFormat, int resourceFormat, FeatureFlagSet requestedFeatures, boolean hidden) {
        public Info(Component description, int format, FeatureFlagSet requestedFeatures) {
            this(description, format, format, requestedFeatures, false);
        }

        public int getFormat(PackType type) {
            return type == PackType.SERVER_DATA ? this.dataFormat : this.resourceFormat;
        }

        public PackCompatibility compatibility(PackType p_249204_) {
            return PackCompatibility.forFormat(this.getFormat(p_249204_), p_249204_);
        }
    }

    public static enum Position {
        TOP,
        BOTTOM;


        public <T> int insert(List<T> p_10471_, T p_10472_, Function<T, Pack> p_10473_, boolean p_10474_) {
            Pack pack;
            int i;
            Position pack$position;
            Position position = pack$position = p_10474_ ? this.opposite() : this;
            if (pack$position == BOTTOM) {
                Pack pack1;
                int j;
                for (j = 0; j < p_10471_.size() && (pack1 = p_10473_.apply(p_10471_.get(j))).isFixedPosition() && pack1.getDefaultPosition() == this; ++j) {
                }
                p_10471_.add(j, p_10472_);
                return j;
            }
            for (i = p_10471_.size() - 1; i >= 0 && (pack = p_10473_.apply(p_10471_.get(i))).isFixedPosition() && pack.getDefaultPosition() == this; --i) {
            }
            p_10471_.add(i + 1, p_10472_);
            return i + 1;
        }

        public Position opposite() {
            return this == TOP ? BOTTOM : TOP;
        }
    }
}

