/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.HolderSet;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ExtraCodecs {
    public static final Codec<JsonElement> JSON = Codec.PASSTHROUGH.xmap(p_253507_ -> (JsonElement)p_253507_.convert((DynamicOps)JsonOps.INSTANCE).getValue(), p_253513_ -> new Dynamic((DynamicOps)JsonOps.INSTANCE, p_253513_));
    public static final Codec<Component> COMPONENT = JSON.flatXmap(p_274861_ -> {
        try {
            return DataResult.success((Object)Component.Serializer.fromJson(p_274861_));
        }
        catch (JsonParseException jsonparseexception) {
            return DataResult.error(jsonparseexception::getMessage);
        }
    }, p_274859_ -> {
        try {
            return DataResult.success((Object)Component.Serializer.toJsonTree(p_274859_));
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return DataResult.error(illegalargumentexception::getMessage);
        }
    });
    public static final Codec<Component> FLAT_COMPONENT = Codec.STRING.flatXmap(p_277276_ -> {
        try {
            return DataResult.success((Object)Component.Serializer.fromJson(p_277276_));
        }
        catch (JsonParseException jsonparseexception) {
            return DataResult.error(jsonparseexception::getMessage);
        }
    }, p_277277_ -> {
        try {
            return DataResult.success((Object)Component.Serializer.toJson(p_277277_));
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return DataResult.error(illegalargumentexception::getMessage);
        }
    });
    public static final Codec<Vector3f> VECTOR3F = Codec.FLOAT.listOf().comapFlatMap(p_253502_ -> Util.fixedSize(p_253502_, 3).map(p_253489_ -> new Vector3f(((Float)p_253489_.get(0)).floatValue(), ((Float)p_253489_.get(1)).floatValue(), ((Float)p_253489_.get(2)).floatValue())), p_269787_ -> List.of(Float.valueOf(p_269787_.x()), Float.valueOf(p_269787_.y()), Float.valueOf(p_269787_.z())));
    public static final Codec<Quaternionf> QUATERNIONF_COMPONENTS = Codec.FLOAT.listOf().comapFlatMap(p_269773_ -> Util.fixedSize(p_269773_, 4).map(p_269785_ -> new Quaternionf(((Float)p_269785_.get(0)).floatValue(), ((Float)p_269785_.get(1)).floatValue(), ((Float)p_269785_.get(2)).floatValue(), ((Float)p_269785_.get(3)).floatValue())), p_269780_ -> List.of(Float.valueOf(p_269780_.x), Float.valueOf(p_269780_.y), Float.valueOf(p_269780_.z), Float.valueOf(p_269780_.w)));
    public static final Codec<AxisAngle4f> AXISANGLE4F = RecordCodecBuilder.create(p_269774_ -> p_269774_.group((App)Codec.FLOAT.fieldOf("angle").forGetter(p_269776_ -> Float.valueOf(p_269776_.angle)), (App)VECTOR3F.fieldOf("axis").forGetter(p_269778_ -> new Vector3f(p_269778_.x, p_269778_.y, p_269778_.z))).apply((Applicative)p_269774_, AxisAngle4f::new));
    public static final Codec<Quaternionf> QUATERNIONF = Codec.either(QUATERNIONF_COMPONENTS, (Codec)AXISANGLE4F.xmap(Quaternionf::new, AxisAngle4f::new)).xmap(p_269779_ -> (Quaternionf)p_269779_.map(p_269781_ -> p_269781_, p_269786_ -> p_269786_), Either::left);
    public static Codec<Matrix4f> MATRIX4F = Codec.FLOAT.listOf().comapFlatMap(p_269788_ -> Util.fixedSize(p_269788_, 16).map(p_269777_ -> {
        Matrix4f matrix4f = new Matrix4f();
        for (int i = 0; i < p_269777_.size(); ++i) {
            matrix4f.setRowColumn(i >> 2, i & 3, ((Float)p_269777_.get(i)).floatValue());
        }
        return matrix4f.determineProperties();
    }), p_269775_ -> {
        FloatArrayList floatlist = new FloatArrayList(16);
        for (int i = 0; i < 16; ++i) {
            floatlist.add(p_269775_.getRowColumn(i >> 2, i & 3));
        }
        return floatlist;
    });
    public static final Codec<Integer> NON_NEGATIVE_INT = ExtraCodecs.intRangeWithMessage(0, Integer.MAX_VALUE, p_275703_ -> "Value must be non-negative: " + p_275703_);
    public static final Codec<Integer> POSITIVE_INT = ExtraCodecs.intRangeWithMessage(1, Integer.MAX_VALUE, p_274847_ -> "Value must be positive: " + p_274847_);
    public static final Codec<Float> POSITIVE_FLOAT = ExtraCodecs.floatRangeMinExclusiveWithMessage(0.0f, Float.MAX_VALUE, p_274876_ -> "Value must be positive: " + p_274876_);
    public static final Codec<Pattern> PATTERN = Codec.STRING.comapFlatMap(p_274857_ -> {
        try {
            return DataResult.success((Object)Pattern.compile(p_274857_));
        }
        catch (PatternSyntaxException patternsyntaxexception) {
            return DataResult.error(() -> "Invalid regex pattern '" + p_274857_ + "': " + patternsyntaxexception.getMessage());
        }
    }, Pattern::pattern);
    public static final Codec<Instant> INSTANT_ISO8601 = ExtraCodecs.instantCodec(DateTimeFormatter.ISO_INSTANT);
    public static final Codec<byte[]> BASE64_STRING = Codec.STRING.comapFlatMap(p_274852_ -> {
        try {
            return DataResult.success((Object)Base64.getDecoder().decode((String)p_274852_));
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return DataResult.error(() -> "Malformed base64 string");
        }
    }, p_216180_ -> Base64.getEncoder().encodeToString((byte[])p_216180_));
    public static final Codec<TagOrElementLocation> TAG_OR_ELEMENT_ID = Codec.STRING.comapFlatMap(p_216169_ -> p_216169_.startsWith("#") ? ResourceLocation.read(p_216169_.substring(1)).map(p_216182_ -> new TagOrElementLocation((ResourceLocation)p_216182_, true)) : ResourceLocation.read(p_216169_).map(p_216165_ -> new TagOrElementLocation((ResourceLocation)p_216165_, false)), TagOrElementLocation::decoratedId);
    public static final Function<Optional<Long>, OptionalLong> toOptionalLong = p_216176_ -> p_216176_.map(OptionalLong::of).orElseGet(OptionalLong::empty);
    public static final Function<OptionalLong, Optional<Long>> fromOptionalLong = p_216178_ -> p_216178_.isPresent() ? Optional.of(p_216178_.getAsLong()) : Optional.empty();
    public static final Codec<BitSet> BIT_SET = Codec.LONG_STREAM.xmap(p_253514_ -> BitSet.valueOf(p_253514_.toArray()), p_253493_ -> Arrays.stream(p_253493_.toLongArray()));
    private static final Codec<Property> PROPERTY = RecordCodecBuilder.create(p_253491_ -> p_253491_.group((App)Codec.STRING.fieldOf("name").forGetter(Property::getName), (App)Codec.STRING.fieldOf("value").forGetter(Property::getValue), (App)Codec.STRING.optionalFieldOf("signature").forGetter(p_253490_ -> Optional.ofNullable(p_253490_.getSignature()))).apply((Applicative)p_253491_, (p_253494_, p_253495_, p_253496_) -> new Property(p_253494_, p_253495_, p_253496_.orElse(null))));
    @VisibleForTesting
    public static final Codec<PropertyMap> PROPERTY_MAP = Codec.either((Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()), (Codec)PROPERTY.listOf()).xmap(p_253515_ -> {
        PropertyMap propertymap = new PropertyMap();
        p_253515_.ifLeft(p_253506_ -> p_253506_.forEach((p_253500_, p_253501_) -> {
            for (String s : p_253501_) {
                propertymap.put(p_253500_, (Object)new Property(p_253500_, s));
            }
        })).ifRight(p_253509_ -> {
            for (Property property : p_253509_) {
                propertymap.put((Object)property.getName(), (Object)property);
            }
        });
        return propertymap;
    }, p_253504_ -> Either.right(p_253504_.values().stream().toList()));
    public static final Codec<GameProfile> GAME_PROFILE = RecordCodecBuilder.create(p_253497_ -> p_253497_.group((App)Codec.mapPair((MapCodec)UUIDUtil.AUTHLIB_CODEC.xmap(Optional::of, p_253517_ -> p_253517_.orElse(null)).optionalFieldOf("id", Optional.empty()), (MapCodec)Codec.STRING.xmap(Optional::of, p_253492_ -> p_253492_.orElse(null)).optionalFieldOf("name", Optional.empty())).flatXmap(ExtraCodecs::mapIdNameToGameProfile, ExtraCodecs::mapGameProfileToIdName).forGetter(Function.identity()), (App)PROPERTY_MAP.optionalFieldOf("properties", (Object)new PropertyMap()).forGetter(GameProfile::getProperties)).apply((Applicative)p_253497_, (p_253518_, p_253519_) -> {
        p_253519_.forEach((p_253511_, p_253512_) -> p_253518_.getProperties().put(p_253511_, p_253512_));
        return p_253518_;
    }));
    public static final Codec<String> NON_EMPTY_STRING = ExtraCodecs.validate(Codec.STRING, (T p_274858_) -> p_274858_.isEmpty() ? DataResult.error(() -> "Expected non-empty string") : DataResult.success((Object)p_274858_));
    public static final Codec<Integer> CODEPOINT = Codec.STRING.comapFlatMap(p_284688_ -> {
        int[] aint = p_284688_.codePoints().toArray();
        return aint.length != 1 ? DataResult.error(() -> "Expected one codepoint, got: " + p_284688_) : DataResult.success((Object)aint[0]);
    }, Character::toString);

    public static <F, S> Codec<Either<F, S>> xor(Codec<F> p_144640_, Codec<S> p_144641_) {
        return new XorCodec<F, S>(p_144640_, p_144641_);
    }

    public static <P, I> Codec<I> intervalCodec(Codec<P> p_184362_, String p_184363_, String p_184364_, BiFunction<P, P, DataResult<I>> p_184365_, Function<I, P> p_184366_, Function<I, P> p_184367_) {
        Codec codec = Codec.list(p_184362_).comapFlatMap(p_184398_ -> Util.fixedSize(p_184398_, 2).flatMap(p_184445_ -> {
            Object p = p_184445_.get(0);
            Object p1 = p_184445_.get(1);
            return (DataResult)p_184365_.apply(p, p1);
        }), p_184459_ -> ImmutableList.of(p_184366_.apply(p_184459_), p_184367_.apply(p_184459_)));
        Codec codec1 = RecordCodecBuilder.create(p_184360_ -> p_184360_.group((App)p_184362_.fieldOf(p_184363_).forGetter(Pair::getFirst), (App)p_184362_.fieldOf(p_184364_).forGetter(Pair::getSecond)).apply((Applicative)p_184360_, Pair::of)).comapFlatMap(p_184392_ -> (DataResult)p_184365_.apply(p_184392_.getFirst(), p_184392_.getSecond()), p_184449_ -> Pair.of(p_184366_.apply(p_184449_), p_184367_.apply(p_184449_)));
        Codec codec2 = new EitherCodec(codec, codec1).xmap(p_184355_ -> p_184355_.map(p_184461_ -> p_184461_, p_184455_ -> p_184455_), Either::left);
        return Codec.either(p_184362_, (Codec)codec2).comapFlatMap(p_184389_ -> (DataResult)p_184389_.map(p_184395_ -> (DataResult)p_184365_.apply(p_184395_, p_184395_), DataResult::success), p_184411_ -> {
            Object p1;
            Object p = p_184366_.apply(p_184411_);
            return Objects.equals(p, p1 = p_184367_.apply(p_184411_)) ? Either.left(p) : Either.right((Object)p_184411_);
        });
    }

    public static <A> Codec.ResultFunction<A> orElsePartial(final A p_184382_) {
        return new Codec.ResultFunction<A>(){

            public <T> DataResult<Pair<A, T>> apply(DynamicOps<T> p_184466_, T p_184467_, DataResult<Pair<A, T>> p_184468_) {
                MutableObject mutableobject = new MutableObject();
                Optional optional = p_184468_.resultOrPartial(arg_0 -> ((MutableObject)mutableobject).setValue(arg_0));
                return optional.isPresent() ? p_184468_ : DataResult.error(() -> "(" + (String)mutableobject.getValue() + " -> using default)", (Object)Pair.of((Object)p_184382_, p_184467_));
            }

            public <T> DataResult<T> coApply(DynamicOps<T> p_184470_, A p_184471_, DataResult<T> p_184472_) {
                return p_184472_;
            }

            public String toString() {
                return "OrElsePartial[" + String.valueOf(p_184382_) + "]";
            }
        };
    }

    public static <E> Codec<E> idResolverCodec(ToIntFunction<E> p_184422_, IntFunction<E> p_184423_, int p_184424_) {
        return Codec.INT.flatXmap(p_184414_ -> Optional.ofNullable(p_184423_.apply((int)p_184414_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element id: " + p_184414_)), p_274850_ -> {
            int i = p_184422_.applyAsInt(p_274850_);
            return i == p_184424_ ? DataResult.error(() -> "Element with unknown id: " + String.valueOf(p_274850_)) : DataResult.success((Object)i);
        });
    }

    public static <E> Codec<E> stringResolverCodec(Function<E, String> p_184406_, Function<String, E> p_184407_) {
        return Codec.STRING.flatXmap(p_184404_ -> Optional.ofNullable(p_184407_.apply((String)p_184404_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element name:" + p_184404_)), p_184401_ -> Optional.ofNullable((String)p_184406_.apply(p_184401_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Element with unknown name: " + String.valueOf(p_184401_))));
    }

    public static <E> Codec<E> orCompressed(final Codec<E> p_184426_, final Codec<E> p_184427_) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E p_184483_, DynamicOps<T> p_184484_, T p_184485_) {
                return p_184484_.compressMaps() ? p_184427_.encode(p_184483_, p_184484_, p_184485_) : p_184426_.encode(p_184483_, p_184484_, p_184485_);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> p_184480_, T p_184481_) {
                return p_184480_.compressMaps() ? p_184427_.decode(p_184480_, p_184481_) : p_184426_.decode(p_184480_, p_184481_);
            }

            public String toString() {
                return String.valueOf(p_184426_) + " orCompressed " + String.valueOf(p_184427_);
            }
        };
    }

    public static <E> Codec<E> overrideLifecycle(Codec<E> p_184369_, final Function<E, Lifecycle> p_184370_, final Function<E, Lifecycle> p_184371_) {
        return p_184369_.mapResult(new Codec.ResultFunction<E>(){

            public <T> DataResult<Pair<E, T>> apply(DynamicOps<T> p_184497_, T p_184498_, DataResult<Pair<E, T>> p_184499_) {
                return p_184499_.result().map(p_184495_ -> p_184499_.setLifecycle((Lifecycle)p_184370_.apply(p_184495_.getFirst()))).orElse(p_184499_);
            }

            public <T> DataResult<T> coApply(DynamicOps<T> p_184501_, E p_184502_, DataResult<T> p_184503_) {
                return p_184503_.setLifecycle((Lifecycle)p_184371_.apply(p_184502_));
            }

            public String toString() {
                return "WithLifecycle[" + String.valueOf(p_184370_) + " " + String.valueOf(p_184371_) + "]";
            }
        });
    }

    public static <T> Codec<T> validate(Codec<T> p_265690_, Function<T, DataResult<T>> p_265223_) {
        return p_265690_.flatXmap(p_265223_, p_265223_);
    }

    public static <T> MapCodec<T> validate(MapCodec<T> p_286613_, Function<T, DataResult<T>> p_286875_) {
        return p_286613_.flatXmap(p_286875_, p_286875_);
    }

    private static Codec<Integer> intRangeWithMessage(int p_144634_, int p_144635_, Function<Integer, String> p_144636_) {
        return ExtraCodecs.validate(Codec.INT, (T p_274889_) -> p_274889_.compareTo(p_144634_) >= 0 && p_274889_.compareTo(p_144635_) <= 0 ? DataResult.success((Object)p_274889_) : DataResult.error(() -> (String)p_144636_.apply((Integer)p_274889_)));
    }

    public static Codec<Integer> intRange(int p_270883_, int p_270323_) {
        return ExtraCodecs.intRangeWithMessage(p_270883_, p_270323_, p_269784_ -> "Value must be within range [" + p_270883_ + ";" + p_270323_ + "]: " + p_269784_);
    }

    private static Codec<Float> floatRangeMinExclusiveWithMessage(float p_184351_, float p_184352_, Function<Float, String> p_184353_) {
        return ExtraCodecs.validate(Codec.FLOAT, (T p_274865_) -> p_274865_.compareTo(Float.valueOf(p_184351_)) > 0 && p_274865_.compareTo(Float.valueOf(p_184352_)) <= 0 ? DataResult.success((Object)p_274865_) : DataResult.error(() -> (String)p_184353_.apply((Float)p_274865_)));
    }

    public static <T> Codec<List<T>> nonEmptyList(Codec<List<T>> p_144638_) {
        return ExtraCodecs.validate(p_144638_, (T p_274853_) -> p_274853_.isEmpty() ? DataResult.error(() -> "List must have contents") : DataResult.success((Object)p_274853_));
    }

    public static <T> Codec<HolderSet<T>> nonEmptyHolderSet(Codec<HolderSet<T>> p_203983_) {
        return ExtraCodecs.validate(p_203983_, (T p_274860_) -> p_274860_.unwrap().right().filter(List::isEmpty).isPresent() ? DataResult.error(() -> "List must have contents") : DataResult.success((Object)p_274860_));
    }

    public static <A> Codec<A> lazyInitializedCodec(Supplier<Codec<A>> p_184416_) {
        return new LazyInitializedCodec<A>(p_184416_);
    }

    public static <E> MapCodec<E> retrieveContext(Function<DynamicOps<?>, DataResult<E>> p_203977_) {
        class ContextRetrievalCodec
        extends MapCodec<E> {
            final /* synthetic */ Function val$p_203977_;

            ContextRetrievalCodec(Function function) {
                this.val$p_203977_ = function;
            }

            public <T> RecordBuilder<T> encode(E p_203993_, DynamicOps<T> p_203994_, RecordBuilder<T> p_203995_) {
                return p_203995_;
            }

            public <T> DataResult<E> decode(DynamicOps<T> p_203990_, MapLike<T> p_203991_) {
                return (DataResult)this.val$p_203977_.apply(p_203990_);
            }

            public String toString() {
                return "ContextRetrievalCodec[" + String.valueOf(this.val$p_203977_) + "]";
            }

            public <T> Stream<T> keys(DynamicOps<T> p_203997_) {
                return Stream.empty();
            }
        }
        return new ContextRetrievalCodec(p_203977_);
    }

    public static <E, L extends Collection<E>, T> Function<L, DataResult<L>> ensureHomogenous(Function<E, T> p_203985_) {
        return p_203980_ -> {
            Iterator iterator = p_203980_.iterator();
            if (iterator.hasNext()) {
                Object t = p_203985_.apply(iterator.next());
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Object t1 = p_203985_.apply(e);
                    if (t1 == t) continue;
                    return DataResult.error(() -> "Mixed type list: element " + String.valueOf(e) + " had type " + String.valueOf(t1) + ", but list is of type " + String.valueOf(t));
                }
            }
            return DataResult.success((Object)p_203980_, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <A> Codec<A> catchDecoderException(final Codec<A> p_216186_) {
        return Codec.of(p_216186_, (Decoder)new Decoder<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> p_216193_, T p_216194_) {
                try {
                    return p_216186_.decode(p_216193_, p_216194_);
                }
                catch (Exception exception) {
                    return DataResult.error(() -> "Caught exception decoding " + String.valueOf(p_216194_) + ": " + exception.getMessage());
                }
            }
        });
    }

    public static Codec<Instant> instantCodec(DateTimeFormatter p_216171_) {
        return Codec.STRING.comapFlatMap(p_274881_ -> {
            try {
                return DataResult.success((Object)Instant.from(p_216171_.parse((CharSequence)p_274881_)));
            }
            catch (Exception exception) {
                return DataResult.error(exception::getMessage);
            }
        }, p_216171_::format);
    }

    public static MapCodec<OptionalLong> asOptionalLong(MapCodec<Optional<Long>> p_216167_) {
        return p_216167_.xmap(toOptionalLong, fromOptionalLong);
    }

    private static DataResult<GameProfile> mapIdNameToGameProfile(Pair<Optional<UUID>, Optional<String>> p_253764_) {
        try {
            return DataResult.success((Object)new GameProfile(((Optional)p_253764_.getFirst()).orElse(null), ((Optional)p_253764_.getSecond()).orElse(null)));
        }
        catch (Throwable throwable) {
            return DataResult.error(throwable::getMessage);
        }
    }

    private static DataResult<Pair<Optional<UUID>, Optional<String>>> mapGameProfileToIdName(GameProfile p_254220_) {
        return DataResult.success((Object)Pair.of(Optional.ofNullable(p_254220_.getId()), Optional.ofNullable(p_254220_.getName())));
    }

    public static Codec<String> sizeLimitedString(int p_265773_, int p_265217_) {
        return ExtraCodecs.validate(Codec.STRING, (T p_274879_) -> {
            int i = p_274879_.length();
            if (i < p_265773_) {
                return DataResult.error(() -> "String \"" + p_274879_ + "\" is too short: " + i + ", expected range [" + p_265773_ + "-" + p_265217_ + "]");
            }
            return i > p_265217_ ? DataResult.error(() -> "String \"" + p_274879_ + "\" is too long: " + i + ", expected range [" + p_265773_ + "-" + p_265217_ + "]") : DataResult.success((Object)p_274879_);
        });
    }

    static final class XorCodec<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> first;
        private final Codec<S> second;

        public XorCodec(Codec<F> p_144660_, Codec<S> p_144661_) {
            this.first = p_144660_;
            this.second = p_144661_;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> p_144679_, T p_144680_) {
            DataResult dataresult = this.first.decode(p_144679_, p_144680_).map(p_144673_ -> p_144673_.mapFirst(Either::left));
            DataResult dataresult1 = this.second.decode(p_144679_, p_144680_).map(p_144667_ -> p_144667_.mapFirst(Either::right));
            Optional optional = dataresult.result();
            Optional optional1 = dataresult1.result();
            if (optional.isPresent() && optional1.isPresent()) {
                return DataResult.error(() -> "Both alternatives read successfully, can not pick the correct one; first: " + String.valueOf(optional.get()) + " second: " + String.valueOf(optional1.get()), (Object)((Pair)optional.get()));
            }
            return optional.isPresent() ? dataresult : dataresult1;
        }

        public <T> DataResult<T> encode(Either<F, S> p_144663_, DynamicOps<T> p_144664_, T p_144665_) {
            return (DataResult)p_144663_.map(p_144677_ -> this.first.encode(p_144677_, p_144664_, p_144665_), p_144671_ -> this.second.encode(p_144671_, p_144664_, p_144665_));
        }

        public boolean equals(Object p_144686_) {
            if (this == p_144686_) {
                return true;
            }
            if (p_144686_ != null && this.getClass() == p_144686_.getClass()) {
                XorCodec xorcodec = (XorCodec)p_144686_;
                return Objects.equals(this.first, xorcodec.first) && Objects.equals(this.second, xorcodec.second);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "XorCodec[" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + "]";
        }
    }

    public static final class EitherCodec<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> first;
        private final Codec<S> second;

        public EitherCodec(Codec<F> p_184508_, Codec<S> p_184509_) {
            this.first = p_184508_;
            this.second = p_184509_;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> p_184530_, T p_184531_) {
            DataResult dataresult = this.first.decode(p_184530_, p_184531_).map(p_184524_ -> p_184524_.mapFirst(Either::left));
            if (!dataresult.error().isPresent()) {
                return dataresult;
            }
            DataResult dataresult1 = this.second.decode(p_184530_, p_184531_).map(p_184515_ -> p_184515_.mapFirst(Either::right));
            return !dataresult1.error().isPresent() ? dataresult1 : dataresult.apply2((p_184517_, p_184518_) -> p_184518_, dataresult1);
        }

        public <T> DataResult<T> encode(Either<F, S> p_184511_, DynamicOps<T> p_184512_, T p_184513_) {
            return (DataResult)p_184511_.map(p_184528_ -> this.first.encode(p_184528_, p_184512_, p_184513_), p_184522_ -> this.second.encode(p_184522_, p_184512_, p_184513_));
        }

        public boolean equals(Object p_184537_) {
            if (this == p_184537_) {
                return true;
            }
            if (p_184537_ != null && this.getClass() == p_184537_.getClass()) {
                EitherCodec eithercodec = (EitherCodec)p_184537_;
                return Objects.equals(this.first, eithercodec.first) && Objects.equals(this.second, eithercodec.second);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "EitherCodec[" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + "]";
        }
    }

    record LazyInitializedCodec<A>(Supplier<Codec<A>> delegate) implements Codec<A>
    {
        LazyInitializedCodec(Supplier<Codec<A>> delegate) {
            this.delegate = delegate = Suppliers.memoize(() -> delegate.get());
        }

        public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> p_184545_, T p_184546_) {
            return this.delegate.get().decode(p_184545_, p_184546_);
        }

        public <T> DataResult<T> encode(A p_184548_, DynamicOps<T> p_184549_, T p_184550_) {
            return this.delegate.get().encode(p_184548_, p_184549_, p_184550_);
        }
    }

    public record TagOrElementLocation(ResourceLocation id, boolean tag) {
        @Override
        public String toString() {
            return this.decoratedId();
        }

        private String decoratedId() {
            return this.tag ? "#" + String.valueOf(this.id) : this.id.toString();
        }
    }
}

