/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import org.slf4j.Logger;

public class FileZipper
implements Closeable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path outputFile;
    private final Path tempFile;
    private final FileSystem fs;

    public FileZipper(Path p_144697_) {
        this.outputFile = p_144697_;
        this.tempFile = p_144697_.resolveSibling(p_144697_.getFileName().toString() + "_tmp");
        try {
            this.fs = Util.ZIP_FILE_SYSTEM_PROVIDER.newFileSystem(this.tempFile, (Map<String, ?>)ImmutableMap.of((Object)"create", (Object)"true"));
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
    }

    public void add(Path p_144704_, String p_144705_) {
        try {
            Path path = this.fs.getPath(File.separator, new String[0]);
            Path path1 = path.resolve(p_144704_.toString());
            Files.createDirectories(path1.getParent(), new FileAttribute[0]);
            Files.write(path1, p_144705_.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
    }

    public void add(Path p_144701_, File p_144702_) {
        try {
            Path path = this.fs.getPath(File.separator, new String[0]);
            Path path1 = path.resolve(p_144701_.toString());
            Files.createDirectories(path1.getParent(), new FileAttribute[0]);
            Files.copy(p_144702_.toPath(), path1, new CopyOption[0]);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
    }

    public void add(Path p_144699_) {
        block10: {
            try {
                Path path = this.fs.getPath(File.separator, new String[0]);
                if (Files.isRegularFile(p_144699_, new LinkOption[0])) {
                    Path path3 = path.resolve(p_144699_.getParent().relativize(p_144699_).toString());
                    Files.copy(path3, p_144699_, new CopyOption[0]);
                    break block10;
                }
                try (Stream<Path> stream = Files.find(p_144699_, Integer.MAX_VALUE, (p_144707_, p_144708_) -> p_144708_.isRegularFile(), new FileVisitOption[0]);){
                    for (Path path1 : stream.collect(Collectors.toList())) {
                        Path path2 = path.resolve(p_144699_.relativize(path1).toString());
                        Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                        Files.copy(path1, path2, new CopyOption[0]);
                    }
                }
            }
            catch (IOException ioexception) {
                throw new UncheckedIOException(ioexception);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.fs.close();
            Files.move(this.tempFile, this.outputFile, new CopyOption[0]);
            LOGGER.info("Compressed to {}", (Object)this.outputFile);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
    }
}

