/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import net.minecraft.util.datafix.fixes.References;

public class ChunkRenamesFix
extends DataFix {
    public ChunkRenamesFix(Schema p_185100_) {
        super(p_185100_, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.CHUNK);
        OpticFinder opticfinder = type.findField("Level");
        OpticFinder opticfinder1 = opticfinder.type().findField("Structures");
        Type type1 = this.getOutputSchema().getType(References.CHUNK);
        Type type2 = type1.findFieldType("structures");
        return this.fixTypeEverywhereTyped("Chunk Renames; purge Level-tag", type, type1, p_199427_ -> {
            Typed typed = p_199427_.getTyped(opticfinder);
            Typed<?> typed1 = ChunkRenamesFix.appendChunkName(typed);
            typed1 = typed1.set(DSL.remainderFinder(), ChunkRenamesFix.mergeRemainders(p_199427_, (Dynamic)typed.get(DSL.remainderFinder())));
            typed1 = ChunkRenamesFix.renameField(typed1, "TileEntities", "block_entities");
            typed1 = ChunkRenamesFix.renameField(typed1, "TileTicks", "block_ticks");
            typed1 = ChunkRenamesFix.renameField(typed1, "Entities", "entities");
            typed1 = ChunkRenamesFix.renameField(typed1, "Sections", "sections");
            typed1 = typed1.updateTyped(opticfinder1, type2, p_185128_ -> ChunkRenamesFix.renameField(p_185128_, "Starts", "starts"));
            typed1 = ChunkRenamesFix.renameField(typed1, "Structures", "structures");
            return typed1.update(DSL.remainderFinder(), p_199429_ -> p_199429_.remove("Level"));
        });
    }

    private static Typed<?> renameField(Typed<?> p_185112_, String p_185113_, String p_185114_) {
        return ChunkRenamesFix.renameFieldHelper(p_185112_, p_185113_, p_185114_, p_185112_.getType().findFieldType(p_185113_)).update(DSL.remainderFinder(), p_199439_ -> p_199439_.remove(p_185113_));
    }

    private static <A> Typed<?> renameFieldHelper(Typed<?> p_185116_, String p_185117_, String p_185118_, Type<A> p_185119_) {
        Type type = DSL.optional((Type)DSL.field((String)p_185117_, p_185119_));
        Type type1 = DSL.optional((Type)DSL.field((String)p_185118_, p_185119_));
        return p_185116_.update(type.finder(), type1, Function.identity());
    }

    private static <A> Typed<Pair<String, A>> appendChunkName(Typed<A> p_185107_) {
        return new Typed(DSL.named((String)"chunk", (Type)p_185107_.getType()), p_185107_.getOps(), (Object)Pair.of((Object)"chunk", (Object)p_185107_.getValue()));
    }

    private static <T> Dynamic<T> mergeRemainders(Typed<?> p_185109_, Dynamic<T> p_185110_) {
        DynamicOps dynamicops = p_185110_.getOps();
        Dynamic dynamic = ((Dynamic)p_185109_.get(DSL.remainderFinder())).convert(dynamicops);
        DataResult dataresult = dynamicops.getMap(p_185110_.getValue()).flatMap(p_199433_ -> dynamicops.mergeToMap(dynamic.getValue(), p_199433_));
        return dataresult.result().map(p_199436_ -> new Dynamic(dynamicops, p_199436_)).orElse(p_185110_);
    }
}

