/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;

public class MobSpawnerEntityIdentifiersFix
extends DataFix {
    public MobSpawnerEntityIdentifiersFix(Schema p_16451_, boolean p_16452_) {
        super(p_16451_, p_16452_);
    }

    private Dynamic<?> fix(Dynamic<?> p_16457_) {
        Optional optional1;
        if (!"MobSpawner".equals(p_16457_.get("id").asString(""))) {
            return p_16457_;
        }
        Optional optional = p_16457_.get("EntityId").asString().result();
        if (optional.isPresent()) {
            Dynamic dynamic = (Dynamic)DataFixUtils.orElse((Optional)p_16457_.get("SpawnData").result(), (Object)p_16457_.emptyMap());
            dynamic = dynamic.set("id", dynamic.createString(((String)optional.get()).isEmpty() ? "Pig" : (String)optional.get()));
            p_16457_ = p_16457_.set("SpawnData", dynamic);
            p_16457_ = p_16457_.remove("EntityId");
        }
        if ((optional1 = p_16457_.get("SpawnPotentials").asStreamOpt().result()).isPresent()) {
            p_16457_ = p_16457_.set("SpawnPotentials", p_16457_.createList(((Stream)optional1.get()).map(p_16459_ -> {
                Optional optional2 = p_16459_.get("Type").asString().result();
                if (optional2.isPresent()) {
                    Dynamic dynamic1 = ((Dynamic)DataFixUtils.orElse((Optional)p_16459_.get("Properties").result(), (Object)p_16459_.emptyMap())).set("id", p_16459_.createString((String)optional2.get()));
                    return p_16459_.set("Entity", dynamic1).remove("Type").remove("Properties");
                }
                return p_16459_;
            })));
        }
        return p_16457_;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(References.UNTAGGED_SPAWNER);
        return this.fixTypeEverywhereTyped("MobSpawnerEntityIdentifiersFix", this.getInputSchema().getType(References.UNTAGGED_SPAWNER), type, p_16455_ -> {
            Dynamic dynamic = (Dynamic)p_16455_.get(DSL.remainderFinder());
            DataResult dataresult = type.readTyped(this.fix(dynamic = dynamic.set("id", dynamic.createString("MobSpawner"))));
            return !dataresult.result().isPresent() ? p_16455_ : (Typed)((Pair)dataresult.result().get()).getFirst();
        });
    }
}

