/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.schemas;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.Hook;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class V1451_6
extends NamespacedSchema {
    public static final String SPECIAL_OBJECTIVE_MARKER = "_special";
    protected static final Hook.HookFunction UNPACK_OBJECTIVE_ID = new Hook.HookFunction(){

        public <T> T apply(DynamicOps<T> p_181096_, T p_181097_) {
            Dynamic dynamic = new Dynamic(p_181096_, p_181097_);
            return (T)((Dynamic)DataFixUtils.orElse(dynamic.get("CriteriaName").asString().get().left().map(p_181094_ -> {
                int i = p_181094_.indexOf(58);
                if (i < 0) {
                    return Pair.of((Object)V1451_6.SPECIAL_OBJECTIVE_MARKER, (Object)p_181094_);
                }
                try {
                    ResourceLocation resourcelocation = ResourceLocation.of(p_181094_.substring(0, i), '.');
                    ResourceLocation resourcelocation1 = ResourceLocation.of(p_181094_.substring(i + 1), '.');
                    return Pair.of((Object)resourcelocation.toString(), (Object)resourcelocation1.toString());
                }
                catch (Exception exception) {
                    return Pair.of((Object)V1451_6.SPECIAL_OBJECTIVE_MARKER, (Object)p_181094_);
                }
            }).map(p_181092_ -> dynamic.set("CriteriaType", dynamic.createMap((Map)ImmutableMap.of((Object)dynamic.createString("type"), (Object)dynamic.createString((String)p_181092_.getFirst()), (Object)dynamic.createString("id"), (Object)dynamic.createString((String)p_181092_.getSecond()))))), (Object)dynamic)).getValue();
        }
    };
    protected static final Hook.HookFunction REPACK_OBJECTIVE_ID = new Hook.HookFunction(){

        private String packWithDot(String p_181103_) {
            ResourceLocation resourcelocation = ResourceLocation.tryParse(p_181103_);
            return resourcelocation != null ? resourcelocation.getNamespace() + "." + resourcelocation.getPath() : p_181103_;
        }

        public <T> T apply(DynamicOps<T> p_181105_, T p_181106_) {
            Dynamic dynamic = new Dynamic(p_181105_, p_181106_);
            Optional<Dynamic> optional = dynamic.get("CriteriaType").get().get().left().flatMap(p_181109_ -> {
                Optional optional1 = p_181109_.get("type").asString().get().left();
                Optional optional2 = p_181109_.get("id").asString().get().left();
                if (optional1.isPresent() && optional2.isPresent()) {
                    String s = (String)optional1.get();
                    return s.equals(V1451_6.SPECIAL_OBJECTIVE_MARKER) ? Optional.of(dynamic.createString((String)optional2.get())) : Optional.of(p_181109_.createString(this.packWithDot(s) + ":" + this.packWithDot((String)optional2.get())));
                }
                return Optional.empty();
            });
            return (T)((Dynamic)DataFixUtils.orElse(optional.map(p_181101_ -> dynamic.set("CriteriaName", p_181101_).remove("CriteriaType")), (Object)dynamic)).getValue();
        }
    };

    public V1451_6(int p_17532_, Schema p_17533_) {
        super(p_17532_, p_17533_);
    }

    public void registerTypes(Schema p_17540_, Map<String, Supplier<TypeTemplate>> p_17541_, Map<String, Supplier<TypeTemplate>> p_17542_) {
        super.registerTypes(p_17540_, p_17541_, p_17542_);
        Supplier<TypeTemplate> supplier = () -> DSL.compoundList((TypeTemplate)References.ITEM_NAME.in(p_17540_), (TypeTemplate)DSL.constType((Type)DSL.intType()));
        p_17540_.registerType(false, References.STATS, () -> DSL.optionalFields((String)"stats", (TypeTemplate)DSL.optionalFields((String)"minecraft:mined", (TypeTemplate)DSL.compoundList((TypeTemplate)References.BLOCK_NAME.in(p_17540_), (TypeTemplate)DSL.constType((Type)DSL.intType())), (String)"minecraft:crafted", (TypeTemplate)((TypeTemplate)supplier.get()), (String)"minecraft:used", (TypeTemplate)((TypeTemplate)supplier.get()), (String)"minecraft:broken", (TypeTemplate)((TypeTemplate)supplier.get()), (String)"minecraft:picked_up", (TypeTemplate)((TypeTemplate)supplier.get()), (TypeTemplate)DSL.optionalFields((String)"minecraft:dropped", (TypeTemplate)((TypeTemplate)supplier.get()), (String)"minecraft:killed", (TypeTemplate)DSL.compoundList((TypeTemplate)References.ENTITY_NAME.in(p_17540_), (TypeTemplate)DSL.constType((Type)DSL.intType())), (String)"minecraft:killed_by", (TypeTemplate)DSL.compoundList((TypeTemplate)References.ENTITY_NAME.in(p_17540_), (TypeTemplate)DSL.constType((Type)DSL.intType())), (String)"minecraft:custom", (TypeTemplate)DSL.compoundList((TypeTemplate)DSL.constType(V1451_6.namespacedString()), (TypeTemplate)DSL.constType((Type)DSL.intType()))))));
        Map<String, Supplier<TypeTemplate>> map = V1451_6.createCriterionTypes(p_17540_);
        p_17540_.registerType(false, References.OBJECTIVE, () -> DSL.hook((TypeTemplate)DSL.optionalFields((String)"CriteriaType", (TypeTemplate)DSL.taggedChoiceLazy((String)"type", (Type)DSL.string(), (Map)map)), (Hook.HookFunction)UNPACK_OBJECTIVE_ID, (Hook.HookFunction)REPACK_OBJECTIVE_ID));
    }

    protected static Map<String, Supplier<TypeTemplate>> createCriterionTypes(Schema p_181078_) {
        Supplier<TypeTemplate> supplier = () -> DSL.optionalFields((String)"id", (TypeTemplate)References.ITEM_NAME.in(p_181078_));
        Supplier<TypeTemplate> supplier1 = () -> DSL.optionalFields((String)"id", (TypeTemplate)References.BLOCK_NAME.in(p_181078_));
        Supplier<TypeTemplate> supplier2 = () -> DSL.optionalFields((String)"id", (TypeTemplate)References.ENTITY_NAME.in(p_181078_));
        HashMap map = Maps.newHashMap();
        map.put("minecraft:mined", supplier1);
        map.put("minecraft:crafted", supplier);
        map.put("minecraft:used", supplier);
        map.put("minecraft:broken", supplier);
        map.put("minecraft:picked_up", supplier);
        map.put("minecraft:dropped", supplier);
        map.put("minecraft:killed", supplier2);
        map.put("minecraft:killed_by", supplier2);
        map.put("minecraft:custom", () -> DSL.optionalFields((String)"id", (TypeTemplate)DSL.constType(V1451_6.namespacedString())));
        map.put(SPECIAL_OBJECTIVE_MARKER, () -> DSL.optionalFields((String)"id", (TypeTemplate)DSL.constType((Type)DSL.string())));
        return map;
    }
}

