/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr;

import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.profiling.jfr.parse.JfrStatsParser;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class SummaryReporter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Runnable onDeregistration;

    protected SummaryReporter(Runnable p_185398_) {
        this.onDeregistration = p_185398_;
    }

    public void recordingStopped(@Nullable Path p_185401_) {
        if (p_185401_ != null) {
            JfrStatsResult jfrstatsresult;
            this.onDeregistration.run();
            SummaryReporter.infoWithFallback(() -> "Dumped flight recorder profiling to " + String.valueOf(p_185401_));
            try {
                jfrstatsresult = JfrStatsParser.parse(p_185401_);
            }
            catch (Throwable throwable1) {
                SummaryReporter.warnWithFallback(() -> "Failed to parse JFR recording", throwable1);
                return;
            }
            try {
                SummaryReporter.infoWithFallback(jfrstatsresult::asJson);
                Path path = p_185401_.resolveSibling("jfr-report-" + StringUtils.substringBefore((String)p_185401_.getFileName().toString(), (String)".jfr") + ".json");
                Files.writeString(path, (CharSequence)jfrstatsresult.asJson(), StandardOpenOption.CREATE);
                SummaryReporter.infoWithFallback(() -> "Dumped recording summary to " + String.valueOf(path));
            }
            catch (Throwable throwable) {
                SummaryReporter.warnWithFallback(() -> "Failed to output JFR report", throwable);
            }
        }
    }

    private static void infoWithFallback(Supplier<String> p_201933_) {
        if (LogUtils.isLoggerActive()) {
            LOGGER.info(p_201933_.get());
        } else {
            Bootstrap.realStdoutPrintln(p_201933_.get());
        }
    }

    private static void warnWithFallback(Supplier<String> p_201935_, Throwable p_201936_) {
        if (LogUtils.isLoggerActive()) {
            LOGGER.warn(p_201935_.get(), p_201936_);
        } else {
            Bootstrap.realStdoutPrintln(p_201935_.get());
            p_201936_.printStackTrace(Bootstrap.STDOUT);
        }
    }
}

