/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.stats;

import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedThread;

public record ThreadAllocationStat(Instant timestamp, String threadName, long totalBytes) {
    private static final String UNKNOWN_THREAD = "unknown";

    public static ThreadAllocationStat from(RecordedEvent p_185804_) {
        RecordedThread recordedthread = p_185804_.getThread("thread");
        String s = recordedthread == null ? UNKNOWN_THREAD : (String)MoreObjects.firstNonNull((Object)recordedthread.getJavaName(), (Object)UNKNOWN_THREAD);
        return new ThreadAllocationStat(p_185804_.getStartTime(), s, p_185804_.getLong("allocated"));
    }

    public static Summary summary(List<ThreadAllocationStat> p_185798_) {
        TreeMap<String, Double> map = new TreeMap<String, Double>();
        Map<String, List<ThreadAllocationStat>> map1 = p_185798_.stream().collect(Collectors.groupingBy(p_185796_ -> p_185796_.threadName));
        map1.forEach((p_185801_, p_185802_) -> {
            if (p_185802_.size() >= 2) {
                ThreadAllocationStat threadallocationstat = (ThreadAllocationStat)p_185802_.get(0);
                ThreadAllocationStat threadallocationstat1 = (ThreadAllocationStat)p_185802_.get(p_185802_.size() - 1);
                long i = Duration.between(threadallocationstat.timestamp, threadallocationstat1.timestamp).getSeconds();
                long j = threadallocationstat1.totalBytes - threadallocationstat.totalBytes;
                map.put((String)p_185801_, (double)j / (double)i);
            }
        });
        return new Summary(map);
    }

    public record Summary(Map<String, Double> allocationsPerSecondByThread) {
    }
}

