/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;

public class WeightedRandom {
    private WeightedRandom() {
    }

    public static int getTotalWeight(List<? extends WeightedEntry> p_146313_) {
        long i = 0L;
        for (WeightedEntry weightedEntry : p_146313_) {
            i += (long)weightedEntry.getWeight().asInt();
        }
        if (i > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)i;
    }

    public static <T extends WeightedEntry> Optional<T> getRandomItem(RandomSource p_216826_, List<T> p_216827_, int p_216828_) {
        if (p_216828_ < 0) {
            throw Util.pauseInIde(new IllegalArgumentException("Negative total weight in getRandomItem"));
        }
        if (p_216828_ == 0) {
            return Optional.empty();
        }
        int i = p_216826_.nextInt(p_216828_);
        return WeightedRandom.getWeightedItem(p_216827_, i);
    }

    public static <T extends WeightedEntry> Optional<T> getWeightedItem(List<T> p_146315_, int p_146316_) {
        for (WeightedEntry t : p_146315_) {
            if ((p_146316_ -= t.getWeight().asInt()) >= 0) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static <T extends WeightedEntry> Optional<T> getRandomItem(RandomSource p_216823_, List<T> p_216824_) {
        return WeightedRandom.getRandomItem(p_216823_, p_216824_, WeightedRandom.getTotalWeight(p_216824_));
    }
}

