/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeMod;

public interface Container
extends Clearable {
    public static final int LARGE_MAX_STACK_SIZE = 64;
    public static final int DEFAULT_DISTANCE_LIMIT = 8;

    public int getContainerSize();

    public boolean isEmpty();

    public ItemStack getItem(int var1);

    public ItemStack removeItem(int var1, int var2);

    public ItemStack removeItemNoUpdate(int var1);

    public void setItem(int var1, ItemStack var2);

    default public int getMaxStackSize() {
        return 64;
    }

    public void setChanged();

    public boolean stillValid(Player var1);

    default public void startOpen(Player p_18955_) {
    }

    default public void stopOpen(Player p_18954_) {
    }

    default public boolean canPlaceItem(int p_18952_, ItemStack p_18953_) {
        return true;
    }

    default public boolean canTakeItem(Container p_273520_, int p_272681_, ItemStack p_273702_) {
        return true;
    }

    default public int countItem(Item p_18948_) {
        int i = 0;
        for (int j = 0; j < this.getContainerSize(); ++j) {
            ItemStack itemstack = this.getItem(j);
            if (!itemstack.getItem().equals(p_18948_)) continue;
            i += itemstack.getCount();
        }
        return i;
    }

    default public boolean hasAnyOf(Set<Item> p_18950_) {
        return this.hasAnyMatching(p_216873_ -> !p_216873_.isEmpty() && p_18950_.contains(p_216873_.getItem()));
    }

    default public boolean hasAnyMatching(Predicate<ItemStack> p_216875_) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemstack = this.getItem(i);
            if (!p_216875_.test(itemstack)) continue;
            return true;
        }
        return false;
    }

    public static boolean stillValidBlockEntity(BlockEntity p_273154_, Player p_273222_) {
        return Container.stillValidBlockEntity(p_273154_, p_273222_, p_273222_.getAttributeValue(ForgeMod.BLOCK_REACH.get()) + 3.5);
    }

    public static boolean stillValidBlockEntity(BlockEntity p_272877_, Player p_272670_, int p_273411_) {
        return Container.stillValidBlockEntity(p_272877_, p_272670_, (double)p_273411_);
    }

    public static boolean stillValidBlockEntity(BlockEntity p_272877_, Player p_272670_, double p_273411_) {
        Level level = p_272877_.getLevel();
        BlockPos blockpos = p_272877_.getBlockPos();
        if (level == null) {
            return false;
        }
        if (level.getBlockEntity(blockpos) != p_272877_) {
            return false;
        }
        return p_272670_.distanceToSqr((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5) <= p_273411_ * p_273411_;
    }
}

