/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;

public class CatSitOnBlockGoal
extends MoveToBlockGoal {
    private final Cat cat;

    public CatSitOnBlockGoal(Cat p_25149_, double p_25150_) {
        super(p_25149_, p_25150_, 8);
        this.cat = p_25149_;
    }

    @Override
    public boolean canUse() {
        return this.cat.isTame() && !this.cat.isOrderedToSit() && super.canUse();
    }

    @Override
    public void start() {
        super.start();
        this.cat.setInSittingPose(false);
    }

    @Override
    public void stop() {
        super.stop();
        this.cat.setInSittingPose(false);
    }

    @Override
    public void tick() {
        super.tick();
        this.cat.setInSittingPose(this.isReachedTarget());
    }

    @Override
    protected boolean isValidTarget(LevelReader p_25153_, BlockPos p_25154_) {
        if (!p_25153_.isEmptyBlock(p_25154_.above())) {
            return false;
        }
        BlockState blockstate = p_25153_.getBlockState(p_25154_);
        if (blockstate.is(Blocks.CHEST)) {
            return ChestBlockEntity.getOpenCount(p_25153_, p_25154_) < 1;
        }
        return blockstate.is(Blocks.FURNACE) && blockstate.getValue(FurnaceBlock.LIT) != false ? true : blockstate.is(BlockTags.BEDS, p_25156_ -> p_25156_.getOptionalValue(BedBlock.PART).map(p_148084_ -> p_148084_ != BedPart.HEAD).orElse(true));
    }
}

