/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public class PlayerHeadItem
extends StandingAndWallBlockItem {
    public static final String TAG_SKULL_OWNER = "SkullOwner";

    public PlayerHeadItem(Block p_42971_, Block p_42972_, Item.Properties p_42973_) {
        super(p_42971_, p_42972_, p_42973_, Direction.DOWN);
    }

    @Override
    public Component getName(ItemStack p_42977_) {
        if (p_42977_.is(Items.PLAYER_HEAD) && p_42977_.hasTag()) {
            CompoundTag compoundtag1;
            String s = null;
            CompoundTag compoundtag = p_42977_.getTag();
            if (compoundtag.contains(TAG_SKULL_OWNER, 8)) {
                s = compoundtag.getString(TAG_SKULL_OWNER);
            } else if (compoundtag.contains(TAG_SKULL_OWNER, 10) && (compoundtag1 = compoundtag.getCompound(TAG_SKULL_OWNER)).contains("Name", 8)) {
                s = compoundtag1.getString("Name");
            }
            if (s != null) {
                return Component.translatable(this.getDescriptionId() + ".named", s);
            }
        }
        return super.getName(p_42977_);
    }

    @Override
    public void verifyTagAfterLoad(CompoundTag p_151179_) {
        super.verifyTagAfterLoad(p_151179_);
        if (p_151179_.contains(TAG_SKULL_OWNER, 8) && !Util.isBlank(p_151179_.getString(TAG_SKULL_OWNER))) {
            GameProfile gameprofile = new GameProfile((UUID)null, p_151179_.getString(TAG_SKULL_OWNER));
            SkullBlockEntity.updateGameprofile(gameprofile, p_151177_ -> p_151179_.put(TAG_SKULL_OWNER, NbtUtils.writeGameProfile(new CompoundTag(), p_151177_)));
        }
    }
}

