/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ShearsItem
extends Item {
    public ShearsItem(Item.Properties p_43074_) {
        super(p_43074_);
    }

    @Override
    public boolean mineBlock(ItemStack p_43078_, Level p_43079_, BlockState p_43080_, BlockPos p_43081_, LivingEntity p_43082_) {
        if (!p_43079_.isClientSide && !p_43080_.is(BlockTags.FIRE)) {
            p_43078_.hurtAndBreak(1, p_43082_, p_43076_ -> p_43076_.broadcastBreakEvent(EquipmentSlot.MAINHAND));
        }
        return !p_43080_.is(BlockTags.LEAVES) && !p_43080_.is(Blocks.COBWEB) && !p_43080_.is(Blocks.GRASS) && !p_43080_.is(Blocks.FERN) && !p_43080_.is(Blocks.DEAD_BUSH) && !p_43080_.is(Blocks.HANGING_ROOTS) && !p_43080_.is(Blocks.VINE) && !p_43080_.is(Blocks.TRIPWIRE) && !p_43080_.is(BlockTags.WOOL) ? super.mineBlock(p_43078_, p_43079_, p_43080_, p_43081_, p_43082_) : true;
    }

    @Override
    public boolean isCorrectToolForDrops(BlockState p_43087_) {
        return p_43087_.is(Blocks.COBWEB) || p_43087_.is(Blocks.REDSTONE_WIRE) || p_43087_.is(Blocks.TRIPWIRE);
    }

    @Override
    public float getDestroySpeed(ItemStack p_43084_, BlockState p_43085_) {
        if (!p_43085_.is(Blocks.COBWEB) && !p_43085_.is(BlockTags.LEAVES)) {
            if (p_43085_.is(BlockTags.WOOL)) {
                return 5.0f;
            }
            return !p_43085_.is(Blocks.VINE) && !p_43085_.is(Blocks.GLOW_LICHEN) ? super.getDestroySpeed(p_43084_, p_43085_) : 2.0f;
        }
        return 15.0f;
    }

    @Override
    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof IForgeShearable) {
            IForgeShearable target = (IForgeShearable)((Object)entity);
            if (entity.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            BlockPos pos = BlockPos.containing(entity.position());
            if (target.isShearable(stack, entity.level(), pos)) {
                List<ItemStack> drops = target.onSheared(playerIn, stack, entity.level(), pos, EnchantmentHelper.getItemEnchantmentLevel(Enchantments.BLOCK_FORTUNE, stack));
                Random rand = new Random();
                drops.forEach(d -> {
                    ItemEntity ent = entity.spawnAtLocation((ItemStack)d, 1.0f);
                    ent.setDeltaMovement(ent.getDeltaMovement().add((rand.nextFloat() - rand.nextFloat()) * 0.1f, rand.nextFloat() * 0.05f, (rand.nextFloat() - rand.nextFloat()) * 0.1f));
                });
                stack.hurtAndBreak(1, playerIn, e -> e.broadcastBreakEvent(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHEARS_ACTIONS.contains(toolAction);
    }

    @Override
    public InteractionResult useOn(UseOnContext p_186371_) {
        GrowingPlantHeadBlock growingplantheadblock;
        BlockPos blockpos;
        Level level = p_186371_.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = p_186371_.getClickedPos());
        Block block = blockstate.getBlock();
        if (block instanceof GrowingPlantHeadBlock && !(growingplantheadblock = (GrowingPlantHeadBlock)block).isMaxAge(blockstate)) {
            Player player = p_186371_.getPlayer();
            ItemStack itemstack = p_186371_.getItemInHand();
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
            }
            level.playSound(player, blockpos, SoundEvents.GROWING_PLANT_CROP, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState blockstate1 = growingplantheadblock.getMaxAgeState(blockstate);
            level.setBlockAndUpdate(blockpos, blockstate1);
            level.gameEvent(GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of(p_186371_.getPlayer(), blockstate1));
            if (player != null) {
                itemstack.hurtAndBreak(1, player, p_186374_ -> p_186374_.broadcastBreakEvent(p_186371_.getHand()));
            }
            return InteractionResult.sidedSuccess(level.isClientSide);
        }
        return super.useOn(p_186371_);
    }
}

