/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class PotionBrewing {
    public static final int BREWING_TIME_SECONDS = 20;
    private static final List<Mix<Potion>> POTION_MIXES = Lists.newArrayList();
    private static final List<Mix<Item>> CONTAINER_MIXES = Lists.newArrayList();
    private static final List<Ingredient> ALLOWED_CONTAINERS = Lists.newArrayList();
    private static final Predicate<ItemStack> ALLOWED_CONTAINER = p_43528_ -> {
        for (Ingredient ingredient : ALLOWED_CONTAINERS) {
            if (!ingredient.test((ItemStack)p_43528_)) continue;
            return true;
        }
        return false;
    };

    public static boolean isIngredient(ItemStack p_43507_) {
        return PotionBrewing.isContainerIngredient(p_43507_) || PotionBrewing.isPotionIngredient(p_43507_);
    }

    protected static boolean isContainerIngredient(ItemStack p_43518_) {
        int j = CONTAINER_MIXES.size();
        for (int i = 0; i < j; ++i) {
            if (!PotionBrewing.CONTAINER_MIXES.get((int)i).ingredient.test(p_43518_)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isPotionIngredient(ItemStack p_43523_) {
        int j = POTION_MIXES.size();
        for (int i = 0; i < j; ++i) {
            if (!PotionBrewing.POTION_MIXES.get((int)i).ingredient.test(p_43523_)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBrewablePotion(Potion p_43512_) {
        int j = POTION_MIXES.size();
        for (int i = 0; i < j; ++i) {
            if (PotionBrewing.POTION_MIXES.get((int)i).to.get() != p_43512_) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMix(ItemStack p_43509_, ItemStack p_43510_) {
        if (!ALLOWED_CONTAINER.test(p_43509_)) {
            return false;
        }
        return PotionBrewing.hasContainerMix(p_43509_, p_43510_) || PotionBrewing.hasPotionMix(p_43509_, p_43510_);
    }

    protected static boolean hasContainerMix(ItemStack p_43520_, ItemStack p_43521_) {
        Item item = p_43520_.getItem();
        int j = CONTAINER_MIXES.size();
        for (int i = 0; i < j; ++i) {
            Mix<Item> mix = CONTAINER_MIXES.get(i);
            if (mix.from.get() != item || !mix.ingredient.test(p_43521_)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasPotionMix(ItemStack p_43525_, ItemStack p_43526_) {
        Potion potion = PotionUtils.getPotion(p_43525_);
        int j = POTION_MIXES.size();
        for (int i = 0; i < j; ++i) {
            Mix<Potion> mix = POTION_MIXES.get(i);
            if (mix.from.get() != potion || !mix.ingredient.test(p_43526_)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack mix(ItemStack p_43530_, ItemStack p_43531_) {
        if (!p_43531_.isEmpty()) {
            int i;
            Potion potion = PotionUtils.getPotion(p_43531_);
            Item item = p_43531_.getItem();
            int j = CONTAINER_MIXES.size();
            for (i = 0; i < j; ++i) {
                Mix<Item> mix = CONTAINER_MIXES.get(i);
                if (mix.from.get() != item || !mix.ingredient.test(p_43530_)) continue;
                return PotionUtils.setPotion(new ItemStack((ItemLike)mix.to.get()), potion);
            }
            int k = POTION_MIXES.size();
            for (i = 0; i < k; ++i) {
                Mix<Potion> mix1 = POTION_MIXES.get(i);
                if (mix1.from.get() != potion || !mix1.ingredient.test(p_43530_)) continue;
                return PotionUtils.setPotion(new ItemStack(item), (Potion)mix1.to.get());
            }
        }
        return p_43531_;
    }

    public static void bootStrap() {
        PotionBrewing.addContainer(Items.POTION);
        PotionBrewing.addContainer(Items.SPLASH_POTION);
        PotionBrewing.addContainer(Items.LINGERING_POTION);
        PotionBrewing.addContainerRecipe(Items.POTION, Items.GUNPOWDER, Items.SPLASH_POTION);
        PotionBrewing.addContainerRecipe(Items.SPLASH_POTION, Items.DRAGON_BREATH, Items.LINGERING_POTION);
        PotionBrewing.addMix(Potions.WATER, Items.GLISTERING_MELON_SLICE, Potions.MUNDANE);
        PotionBrewing.addMix(Potions.WATER, Items.GHAST_TEAR, Potions.MUNDANE);
        PotionBrewing.addMix(Potions.WATER, Items.RABBIT_FOOT, Potions.MUNDANE);
        PotionBrewing.addMix(Potions.WATER, Items.BLAZE_POWDER, Potions.MUNDANE);
        PotionBrewing.addMix(Potions.WATER, Items.SPIDER_EYE, Potions.MUNDANE);
        PotionBrewing.addMix(Potions.WATER, Items.SUGAR, Potions.MUNDANE);
        PotionBrewing.addMix(Potions.WATER, Items.MAGMA_CREAM, Potions.MUNDANE);
        PotionBrewing.addMix(Potions.WATER, Items.GLOWSTONE_DUST, Potions.THICK);
        PotionBrewing.addMix(Potions.WATER, Items.REDSTONE, Potions.MUNDANE);
        PotionBrewing.addMix(Potions.WATER, Items.NETHER_WART, Potions.AWKWARD);
        PotionBrewing.addMix(Potions.AWKWARD, Items.GOLDEN_CARROT, Potions.NIGHT_VISION);
        PotionBrewing.addMix(Potions.NIGHT_VISION, Items.REDSTONE, Potions.LONG_NIGHT_VISION);
        PotionBrewing.addMix(Potions.NIGHT_VISION, Items.FERMENTED_SPIDER_EYE, Potions.INVISIBILITY);
        PotionBrewing.addMix(Potions.LONG_NIGHT_VISION, Items.FERMENTED_SPIDER_EYE, Potions.LONG_INVISIBILITY);
        PotionBrewing.addMix(Potions.INVISIBILITY, Items.REDSTONE, Potions.LONG_INVISIBILITY);
        PotionBrewing.addMix(Potions.AWKWARD, Items.MAGMA_CREAM, Potions.FIRE_RESISTANCE);
        PotionBrewing.addMix(Potions.FIRE_RESISTANCE, Items.REDSTONE, Potions.LONG_FIRE_RESISTANCE);
        PotionBrewing.addMix(Potions.AWKWARD, Items.RABBIT_FOOT, Potions.LEAPING);
        PotionBrewing.addMix(Potions.LEAPING, Items.REDSTONE, Potions.LONG_LEAPING);
        PotionBrewing.addMix(Potions.LEAPING, Items.GLOWSTONE_DUST, Potions.STRONG_LEAPING);
        PotionBrewing.addMix(Potions.LEAPING, Items.FERMENTED_SPIDER_EYE, Potions.SLOWNESS);
        PotionBrewing.addMix(Potions.LONG_LEAPING, Items.FERMENTED_SPIDER_EYE, Potions.LONG_SLOWNESS);
        PotionBrewing.addMix(Potions.SLOWNESS, Items.REDSTONE, Potions.LONG_SLOWNESS);
        PotionBrewing.addMix(Potions.SLOWNESS, Items.GLOWSTONE_DUST, Potions.STRONG_SLOWNESS);
        PotionBrewing.addMix(Potions.AWKWARD, Items.TURTLE_HELMET, Potions.TURTLE_MASTER);
        PotionBrewing.addMix(Potions.TURTLE_MASTER, Items.REDSTONE, Potions.LONG_TURTLE_MASTER);
        PotionBrewing.addMix(Potions.TURTLE_MASTER, Items.GLOWSTONE_DUST, Potions.STRONG_TURTLE_MASTER);
        PotionBrewing.addMix(Potions.SWIFTNESS, Items.FERMENTED_SPIDER_EYE, Potions.SLOWNESS);
        PotionBrewing.addMix(Potions.LONG_SWIFTNESS, Items.FERMENTED_SPIDER_EYE, Potions.LONG_SLOWNESS);
        PotionBrewing.addMix(Potions.AWKWARD, Items.SUGAR, Potions.SWIFTNESS);
        PotionBrewing.addMix(Potions.SWIFTNESS, Items.REDSTONE, Potions.LONG_SWIFTNESS);
        PotionBrewing.addMix(Potions.SWIFTNESS, Items.GLOWSTONE_DUST, Potions.STRONG_SWIFTNESS);
        PotionBrewing.addMix(Potions.AWKWARD, Items.PUFFERFISH, Potions.WATER_BREATHING);
        PotionBrewing.addMix(Potions.WATER_BREATHING, Items.REDSTONE, Potions.LONG_WATER_BREATHING);
        PotionBrewing.addMix(Potions.AWKWARD, Items.GLISTERING_MELON_SLICE, Potions.HEALING);
        PotionBrewing.addMix(Potions.HEALING, Items.GLOWSTONE_DUST, Potions.STRONG_HEALING);
        PotionBrewing.addMix(Potions.HEALING, Items.FERMENTED_SPIDER_EYE, Potions.HARMING);
        PotionBrewing.addMix(Potions.STRONG_HEALING, Items.FERMENTED_SPIDER_EYE, Potions.STRONG_HARMING);
        PotionBrewing.addMix(Potions.HARMING, Items.GLOWSTONE_DUST, Potions.STRONG_HARMING);
        PotionBrewing.addMix(Potions.POISON, Items.FERMENTED_SPIDER_EYE, Potions.HARMING);
        PotionBrewing.addMix(Potions.LONG_POISON, Items.FERMENTED_SPIDER_EYE, Potions.HARMING);
        PotionBrewing.addMix(Potions.STRONG_POISON, Items.FERMENTED_SPIDER_EYE, Potions.STRONG_HARMING);
        PotionBrewing.addMix(Potions.AWKWARD, Items.SPIDER_EYE, Potions.POISON);
        PotionBrewing.addMix(Potions.POISON, Items.REDSTONE, Potions.LONG_POISON);
        PotionBrewing.addMix(Potions.POISON, Items.GLOWSTONE_DUST, Potions.STRONG_POISON);
        PotionBrewing.addMix(Potions.AWKWARD, Items.GHAST_TEAR, Potions.REGENERATION);
        PotionBrewing.addMix(Potions.REGENERATION, Items.REDSTONE, Potions.LONG_REGENERATION);
        PotionBrewing.addMix(Potions.REGENERATION, Items.GLOWSTONE_DUST, Potions.STRONG_REGENERATION);
        PotionBrewing.addMix(Potions.AWKWARD, Items.BLAZE_POWDER, Potions.STRENGTH);
        PotionBrewing.addMix(Potions.STRENGTH, Items.REDSTONE, Potions.LONG_STRENGTH);
        PotionBrewing.addMix(Potions.STRENGTH, Items.GLOWSTONE_DUST, Potions.STRONG_STRENGTH);
        PotionBrewing.addMix(Potions.WATER, Items.FERMENTED_SPIDER_EYE, Potions.WEAKNESS);
        PotionBrewing.addMix(Potions.WEAKNESS, Items.REDSTONE, Potions.LONG_WEAKNESS);
        PotionBrewing.addMix(Potions.AWKWARD, Items.PHANTOM_MEMBRANE, Potions.SLOW_FALLING);
        PotionBrewing.addMix(Potions.SLOW_FALLING, Items.REDSTONE, Potions.LONG_SLOW_FALLING);
    }

    private static void addContainerRecipe(Item p_43503_, Item p_43504_, Item p_43505_) {
        if (!(p_43503_ instanceof PotionItem)) {
            throw new IllegalArgumentException("Expected a potion, got: " + String.valueOf(BuiltInRegistries.ITEM.getKey(p_43503_)));
        }
        if (!(p_43505_ instanceof PotionItem)) {
            throw new IllegalArgumentException("Expected a potion, got: " + String.valueOf(BuiltInRegistries.ITEM.getKey(p_43505_)));
        }
        CONTAINER_MIXES.add(new Mix<Item>(ForgeRegistries.ITEMS, p_43503_, Ingredient.of(p_43504_), p_43505_));
    }

    private static void addContainer(Item p_43501_) {
        if (!(p_43501_ instanceof PotionItem)) {
            throw new IllegalArgumentException("Expected a potion, got: " + String.valueOf(BuiltInRegistries.ITEM.getKey(p_43501_)));
        }
        ALLOWED_CONTAINERS.add(Ingredient.of(p_43501_));
    }

    private static void addMix(Potion p_43514_, Item p_43515_, Potion p_43516_) {
        POTION_MIXES.add(new Mix<Potion>(ForgeRegistries.POTIONS, p_43514_, Ingredient.of(p_43515_), p_43516_));
    }

    public static class Mix<T> {
        public final Holder.Reference<T> from;
        public final Ingredient ingredient;
        public final Holder.Reference<T> to;

        public Mix(IForgeRegistry<T> registry, T p_43536_, Ingredient p_43537_, T p_43538_) {
            this.from = registry.getDelegateOrThrow(p_43536_);
            this.ingredient = p_43537_;
            this.to = registry.getDelegateOrThrow(p_43538_);
        }
    }
}

