/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.armortrim;

import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class TrimMaterials {
    public static final ResourceKey<TrimMaterial> QUARTZ = TrimMaterials.registryKey("quartz");
    public static final ResourceKey<TrimMaterial> IRON = TrimMaterials.registryKey("iron");
    public static final ResourceKey<TrimMaterial> NETHERITE = TrimMaterials.registryKey("netherite");
    public static final ResourceKey<TrimMaterial> REDSTONE = TrimMaterials.registryKey("redstone");
    public static final ResourceKey<TrimMaterial> COPPER = TrimMaterials.registryKey("copper");
    public static final ResourceKey<TrimMaterial> GOLD = TrimMaterials.registryKey("gold");
    public static final ResourceKey<TrimMaterial> EMERALD = TrimMaterials.registryKey("emerald");
    public static final ResourceKey<TrimMaterial> DIAMOND = TrimMaterials.registryKey("diamond");
    public static final ResourceKey<TrimMaterial> LAPIS = TrimMaterials.registryKey("lapis");
    public static final ResourceKey<TrimMaterial> AMETHYST = TrimMaterials.registryKey("amethyst");

    public static void bootstrap(BootstapContext<TrimMaterial> p_267033_) {
        TrimMaterials.register(p_267033_, QUARTZ, Items.QUARTZ, Style.EMPTY.withColor(14931140), 0.1f);
        TrimMaterials.register(p_267033_, IRON, Items.IRON_INGOT, Style.EMPTY.withColor(0xECECEC), 0.2f, Map.of(ArmorMaterials.IRON, "iron_darker"));
        TrimMaterials.register(p_267033_, NETHERITE, Items.NETHERITE_INGOT, Style.EMPTY.withColor(6445145), 0.3f, Map.of(ArmorMaterials.NETHERITE, "netherite_darker"));
        TrimMaterials.register(p_267033_, REDSTONE, Items.REDSTONE, Style.EMPTY.withColor(9901575), 0.4f);
        TrimMaterials.register(p_267033_, COPPER, Items.COPPER_INGOT, Style.EMPTY.withColor(11823181), 0.5f);
        TrimMaterials.register(p_267033_, GOLD, Items.GOLD_INGOT, Style.EMPTY.withColor(14594349), 0.6f, Map.of(ArmorMaterials.GOLD, "gold_darker"));
        TrimMaterials.register(p_267033_, EMERALD, Items.EMERALD, Style.EMPTY.withColor(1155126), 0.7f);
        TrimMaterials.register(p_267033_, DIAMOND, Items.DIAMOND, Style.EMPTY.withColor(7269586), 0.8f, Map.of(ArmorMaterials.DIAMOND, "diamond_darker"));
        TrimMaterials.register(p_267033_, LAPIS, Items.LAPIS_LAZULI, Style.EMPTY.withColor(4288151), 0.9f);
        TrimMaterials.register(p_267033_, AMETHYST, Items.AMETHYST_SHARD, Style.EMPTY.withColor(10116294), 1.0f);
    }

    public static Optional<Holder.Reference<TrimMaterial>> getFromIngredient(RegistryAccess p_266981_, ItemStack p_267327_) {
        return p_266981_.registryOrThrow(Registries.TRIM_MATERIAL).holders().filter(p_266876_ -> p_267327_.is(((TrimMaterial)p_266876_.value()).ingredient())).findFirst();
    }

    private static void register(BootstapContext<TrimMaterial> p_268176_, ResourceKey<TrimMaterial> p_268293_, Item p_268156_, Style p_268174_, float p_268274_) {
        TrimMaterials.register(p_268176_, p_268293_, p_268156_, p_268174_, p_268274_, Map.of());
    }

    private static void register(BootstapContext<TrimMaterial> p_268244_, ResourceKey<TrimMaterial> p_268139_, Item p_268311_, Style p_268232_, float p_268197_, Map<ArmorMaterials, String> p_268352_) {
        TrimMaterial trimmaterial = TrimMaterial.create(p_268139_.location().getPath(), p_268311_, p_268197_, Component.translatable(Util.makeDescriptionId("trim_material", p_268139_.location())).withStyle(p_268232_), p_268352_);
        p_268244_.register(p_268139_, trimmaterial);
    }

    private static ResourceKey<TrimMaterial> registryKey(String p_266965_) {
        return ResourceKey.create(Registries.TRIM_MATERIAL, new ResourceLocation(p_266965_));
    }
}

