/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class FireworkRocketRecipe
extends CustomRecipe {
    private static final Ingredient PAPER_INGREDIENT = Ingredient.of(Items.PAPER);
    private static final Ingredient GUNPOWDER_INGREDIENT = Ingredient.of(Items.GUNPOWDER);
    private static final Ingredient STAR_INGREDIENT = Ingredient.of(Items.FIREWORK_STAR);

    public FireworkRocketRecipe(ResourceLocation p_250923_, CraftingBookCategory p_250134_) {
        super(p_250923_, p_250134_);
    }

    @Override
    public boolean matches(CraftingContainer p_43854_, Level p_43855_) {
        boolean flag = false;
        int i = 0;
        for (int j = 0; j < p_43854_.getContainerSize(); ++j) {
            ItemStack itemstack = p_43854_.getItem(j);
            if (itemstack.isEmpty()) continue;
            if (PAPER_INGREDIENT.test(itemstack)) {
                if (flag) {
                    return false;
                }
                flag = true;
                continue;
            }
            if (!(GUNPOWDER_INGREDIENT.test(itemstack) ? ++i > 3 : !STAR_INGREDIENT.test(itemstack))) continue;
            return false;
        }
        return flag && i >= 1;
    }

    @Override
    public ItemStack assemble(CraftingContainer p_43852_, RegistryAccess p_266791_) {
        ItemStack itemstack = new ItemStack(Items.FIREWORK_ROCKET, 3);
        CompoundTag compoundtag = itemstack.getOrCreateTagElement("Fireworks");
        ListTag listtag = new ListTag();
        int i = 0;
        for (int j = 0; j < p_43852_.getContainerSize(); ++j) {
            CompoundTag compoundtag1;
            ItemStack itemstack1 = p_43852_.getItem(j);
            if (itemstack1.isEmpty()) continue;
            if (GUNPOWDER_INGREDIENT.test(itemstack1)) {
                ++i;
                continue;
            }
            if (!STAR_INGREDIENT.test(itemstack1) || (compoundtag1 = itemstack1.getTagElement("Explosion")) == null) continue;
            listtag.add(compoundtag1);
        }
        compoundtag.putByte("Flight", (byte)i);
        if (!listtag.isEmpty()) {
            compoundtag.put("Explosions", listtag);
        }
        return itemstack;
    }

    @Override
    public boolean canCraftInDimensions(int p_43844_, int p_43845_) {
        return p_43844_ * p_43845_ >= 2;
    }

    @Override
    public ItemStack getResultItem(RegistryAccess p_267261_) {
        return new ItemStack(Items.FIREWORK_ROCKET);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.FIREWORK_ROCKET;
    }
}

