/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class SimpleCookingSerializer<T extends AbstractCookingRecipe>
implements RecipeSerializer<T> {
    private final int defaultCookingTime;
    private final CookieBaker<T> factory;

    public SimpleCookingSerializer(CookieBaker<T> p_44330_, int p_44331_) {
        this.defaultCookingTime = p_44331_;
        this.factory = p_44330_;
    }

    @Override
    public T fromJson(ResourceLocation p_44347_, JsonObject p_44348_) {
        ItemStack itemstack;
        String s = GsonHelper.getAsString(p_44348_, "group", "");
        CookingBookCategory cookingbookcategory = CookingBookCategory.CODEC.byName(GsonHelper.getAsString(p_44348_, "category", null), CookingBookCategory.MISC);
        JsonArray jsonelement = GsonHelper.isArrayNode(p_44348_, "ingredient") ? GsonHelper.getAsJsonArray(p_44348_, "ingredient") : GsonHelper.getAsJsonObject(p_44348_, "ingredient");
        Ingredient ingredient = Ingredient.fromJson((JsonElement)jsonelement, false);
        if (!p_44348_.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (p_44348_.get("result").isJsonObject()) {
            itemstack = ShapedRecipe.itemStackFromJson(GsonHelper.getAsJsonObject(p_44348_, "result"));
        } else {
            String s1 = GsonHelper.getAsString(p_44348_, "result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            itemstack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.getOptional(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
        }
        float f = GsonHelper.getAsFloat(p_44348_, "experience", 0.0f);
        int i = GsonHelper.getAsInt(p_44348_, "cookingtime", this.defaultCookingTime);
        return this.factory.create(p_44347_, s, cookingbookcategory, ingredient, itemstack, f, i);
    }

    @Override
    public T fromNetwork(ResourceLocation p_44350_, FriendlyByteBuf p_44351_) {
        String s = p_44351_.readUtf();
        CookingBookCategory cookingbookcategory = p_44351_.readEnum(CookingBookCategory.class);
        Ingredient ingredient = Ingredient.fromNetwork(p_44351_);
        ItemStack itemstack = p_44351_.readItem();
        float f = p_44351_.readFloat();
        int i = p_44351_.readVarInt();
        return this.factory.create(p_44350_, s, cookingbookcategory, ingredient, itemstack, f, i);
    }

    @Override
    public void toNetwork(FriendlyByteBuf p_44335_, T p_44336_) {
        p_44335_.writeUtf(((AbstractCookingRecipe)p_44336_).group);
        p_44335_.writeEnum(((AbstractCookingRecipe)p_44336_).category());
        ((AbstractCookingRecipe)p_44336_).ingredient.toNetwork(p_44335_);
        p_44335_.writeItem(((AbstractCookingRecipe)p_44336_).result);
        p_44335_.writeFloat(((AbstractCookingRecipe)p_44336_).experience);
        p_44335_.writeVarInt(((AbstractCookingRecipe)p_44336_).cookingTime);
    }

    static interface CookieBaker<T extends AbstractCookingRecipe> {
        public T create(ResourceLocation var1, String var2, CookingBookCategory var3, Ingredient var4, ItemStack var5, float var6, int var7);
    }
}

