/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public abstract class SingleItemRecipe
implements Recipe<Container> {
    protected final Ingredient ingredient;
    protected final ItemStack result;
    private final RecipeType<?> type;
    private final RecipeSerializer<?> serializer;
    protected final ResourceLocation id;
    protected final String group;

    public SingleItemRecipe(RecipeType<?> p_44416_, RecipeSerializer<?> p_44417_, ResourceLocation p_44418_, String p_44419_, Ingredient p_44420_, ItemStack p_44421_) {
        this.type = p_44416_;
        this.serializer = p_44417_;
        this.id = p_44418_;
        this.group = p_44419_;
        this.ingredient = p_44420_;
        this.result = p_44421_;
    }

    @Override
    public RecipeType<?> getType() {
        return this.type;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return this.serializer;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public ItemStack getResultItem(RegistryAccess p_266964_) {
        return this.result;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        NonNullList<Ingredient> nonnulllist = NonNullList.create();
        nonnulllist.add(this.ingredient);
        return nonnulllist;
    }

    @Override
    public boolean canCraftInDimensions(int p_44424_, int p_44425_) {
        return true;
    }

    @Override
    public ItemStack assemble(Container p_44427_, RegistryAccess p_266999_) {
        return this.result.copy();
    }

    public static class Serializer<T extends SingleItemRecipe>
    implements RecipeSerializer<T> {
        final SingleItemMaker<T> factory;

        protected Serializer(SingleItemMaker<T> p_44435_) {
            this.factory = p_44435_;
        }

        @Override
        public T fromJson(ResourceLocation p_44449_, JsonObject p_44450_) {
            String s = GsonHelper.getAsString(p_44450_, "group", "");
            Ingredient ingredient = GsonHelper.isArrayNode(p_44450_, "ingredient") ? Ingredient.fromJson((JsonElement)GsonHelper.getAsJsonArray(p_44450_, "ingredient"), false) : Ingredient.fromJson((JsonElement)GsonHelper.getAsJsonObject(p_44450_, "ingredient"), false);
            String s1 = GsonHelper.getAsString(p_44450_, "result");
            int i = GsonHelper.getAsInt(p_44450_, "count");
            ItemStack itemstack = new ItemStack(BuiltInRegistries.ITEM.get(new ResourceLocation(s1)), i);
            return this.factory.create(p_44449_, s, ingredient, itemstack);
        }

        @Override
        public T fromNetwork(ResourceLocation p_44452_, FriendlyByteBuf p_44453_) {
            String s = p_44453_.readUtf();
            Ingredient ingredient = Ingredient.fromNetwork(p_44453_);
            ItemStack itemstack = p_44453_.readItem();
            return this.factory.create(p_44452_, s, ingredient, itemstack);
        }

        @Override
        public void toNetwork(FriendlyByteBuf p_44440_, T p_44441_) {
            p_44440_.writeUtf(((SingleItemRecipe)p_44441_).group);
            ((SingleItemRecipe)p_44441_).ingredient.toNetwork(p_44440_);
            p_44440_.writeItem(((SingleItemRecipe)p_44441_).result);
        }

        static interface SingleItemMaker<T extends SingleItemRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4);
        }
    }
}

