/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.SweepingEdgeEnchantment;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class EnchantmentHelper {
    private static final String TAG_ENCH_ID = "id";
    private static final String TAG_ENCH_LEVEL = "lvl";
    private static final float SWIFT_SNEAK_EXTRA_FACTOR = 0.15f;

    public static CompoundTag storeEnchantment(@Nullable ResourceLocation p_182444_, int p_182445_) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putString(TAG_ENCH_ID, String.valueOf(p_182444_));
        compoundtag.putShort(TAG_ENCH_LEVEL, (short)p_182445_);
        return compoundtag;
    }

    public static void setEnchantmentLevel(CompoundTag p_182441_, int p_182442_) {
        p_182441_.putShort(TAG_ENCH_LEVEL, (short)p_182442_);
    }

    public static int getEnchantmentLevel(CompoundTag p_182439_) {
        return Mth.clamp(p_182439_.getInt(TAG_ENCH_LEVEL), 0, 255);
    }

    @Nullable
    public static ResourceLocation getEnchantmentId(CompoundTag p_182447_) {
        return ResourceLocation.tryParse(p_182447_.getString(TAG_ENCH_ID));
    }

    @Nullable
    public static ResourceLocation getEnchantmentId(Enchantment p_182433_) {
        return BuiltInRegistries.ENCHANTMENT.getKey(p_182433_);
    }

    @Deprecated
    public static int getItemEnchantmentLevel(Enchantment p_44844_, ItemStack p_44845_) {
        return p_44845_.getEnchantmentLevel(p_44844_);
    }

    public static int getTagEnchantmentLevel(Enchantment p_44844_, ItemStack p_44845_) {
        if (p_44845_.isEmpty()) {
            return 0;
        }
        ResourceLocation resourcelocation = EnchantmentHelper.getEnchantmentId(p_44844_);
        ListTag listtag = p_44845_.getEnchantmentTags();
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.getCompound(i);
            ResourceLocation resourcelocation1 = EnchantmentHelper.getEnchantmentId(compoundtag);
            if (resourcelocation1 == null || !resourcelocation1.equals(resourcelocation)) continue;
            return EnchantmentHelper.getEnchantmentLevel(compoundtag);
        }
        return 0;
    }

    public static Map<Enchantment, Integer> getEnchantments(ItemStack p_44832_) {
        ListTag listtag = p_44832_.is(Items.ENCHANTED_BOOK) ? EnchantedBookItem.getEnchantments(p_44832_) : p_44832_.getEnchantmentTags();
        return EnchantmentHelper.deserializeEnchantments(listtag);
    }

    public static Map<Enchantment, Integer> deserializeEnchantments(ListTag p_44883_) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (int i = 0; i < p_44883_.size(); ++i) {
            CompoundTag compoundtag = p_44883_.getCompound(i);
            BuiltInRegistries.ENCHANTMENT.getOptional(EnchantmentHelper.getEnchantmentId(compoundtag)).ifPresent(p_44871_ -> map.put(p_44871_, EnchantmentHelper.getEnchantmentLevel(compoundtag)));
        }
        return map;
    }

    public static void setEnchantments(Map<Enchantment, Integer> p_44866_, ItemStack p_44867_) {
        ListTag listtag = new ListTag();
        for (Map.Entry<Enchantment, Integer> entry : p_44866_.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            listtag.add(EnchantmentHelper.storeEnchantment(EnchantmentHelper.getEnchantmentId(enchantment), i));
            if (!p_44867_.is(Items.ENCHANTED_BOOK)) continue;
            EnchantedBookItem.addEnchantment(p_44867_, new EnchantmentInstance(enchantment, i));
        }
        if (listtag.isEmpty()) {
            p_44867_.removeTagKey("Enchantments");
        } else if (!p_44867_.is(Items.ENCHANTED_BOOK)) {
            p_44867_.addTagElement("Enchantments", listtag);
        }
    }

    private static void runIterationOnItem(EnchantmentVisitor p_44851_, ItemStack p_44852_) {
        if (!p_44852_.isEmpty()) {
            for (Map.Entry<Enchantment, Integer> entry : p_44852_.getAllEnchantments().entrySet()) {
                p_44851_.accept(entry.getKey(), entry.getValue());
            }
            return;
        }
    }

    private static void runIterationOnInventory(EnchantmentVisitor p_44854_, Iterable<ItemStack> p_44855_) {
        for (ItemStack itemstack : p_44855_) {
            EnchantmentHelper.runIterationOnItem(p_44854_, itemstack);
        }
    }

    public static int getDamageProtection(Iterable<ItemStack> p_44857_, DamageSource p_44858_) {
        MutableInt mutableint = new MutableInt();
        EnchantmentHelper.runIterationOnInventory((p_44892_, p_44893_) -> mutableint.add(p_44892_.getDamageProtection(p_44893_, p_44858_)), p_44857_);
        return mutableint.intValue();
    }

    public static float getDamageBonus(ItemStack p_44834_, MobType p_44835_) {
        MutableFloat mutablefloat = new MutableFloat();
        EnchantmentHelper.runIterationOnItem((p_44887_, p_44888_) -> mutablefloat.add(p_44887_.getDamageBonus(p_44888_, p_44835_, p_44834_)), p_44834_);
        return mutablefloat.floatValue();
    }

    public static float getSweepingDamageRatio(LivingEntity p_44822_) {
        int i = EnchantmentHelper.getEnchantmentLevel(Enchantments.SWEEPING_EDGE, p_44822_);
        return i > 0 ? SweepingEdgeEnchantment.getSweepingDamageRatio(i) : 0.0f;
    }

    public static void doPostHurtEffects(LivingEntity p_44824_, Entity p_44825_) {
        EnchantmentVisitor enchantmenthelper$enchantmentvisitor = (p_44902_, p_44903_) -> p_44902_.doPostHurt(p_44824_, p_44825_, p_44903_);
        if (p_44824_ != null) {
            EnchantmentHelper.runIterationOnInventory(enchantmenthelper$enchantmentvisitor, p_44824_.getAllSlots());
        }
    }

    public static void doPostDamageEffects(LivingEntity p_44897_, Entity p_44898_) {
        EnchantmentVisitor enchantmenthelper$enchantmentvisitor = (p_44829_, p_44830_) -> p_44829_.doPostAttack(p_44897_, p_44898_, p_44830_);
        if (p_44897_ != null) {
            EnchantmentHelper.runIterationOnInventory(enchantmenthelper$enchantmentvisitor, p_44897_.getAllSlots());
        }
    }

    public static int getEnchantmentLevel(Enchantment p_44837_, LivingEntity p_44838_) {
        Collection<ItemStack> iterable = p_44837_.getSlotItems(p_44838_).values();
        if (iterable == null) {
            return 0;
        }
        int i = 0;
        for (ItemStack itemstack : iterable) {
            int j = EnchantmentHelper.getItemEnchantmentLevel(p_44837_, itemstack);
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public static float getSneakingSpeedBonus(LivingEntity p_220303_) {
        return (float)EnchantmentHelper.getEnchantmentLevel(Enchantments.SWIFT_SNEAK, p_220303_) * 0.15f;
    }

    public static int getKnockbackBonus(LivingEntity p_44895_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.KNOCKBACK, p_44895_);
    }

    public static int getFireAspect(LivingEntity p_44915_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.FIRE_ASPECT, p_44915_);
    }

    public static int getRespiration(LivingEntity p_44919_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.RESPIRATION, p_44919_);
    }

    public static int getDepthStrider(LivingEntity p_44923_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.DEPTH_STRIDER, p_44923_);
    }

    public static int getBlockEfficiency(LivingEntity p_44927_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.BLOCK_EFFICIENCY, p_44927_);
    }

    public static int getFishingLuckBonus(ItemStack p_44905_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.FISHING_LUCK, p_44905_);
    }

    public static int getFishingSpeedBonus(ItemStack p_44917_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.FISHING_SPEED, p_44917_);
    }

    public static int getMobLooting(LivingEntity p_44931_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.MOB_LOOTING, p_44931_);
    }

    public static boolean hasAquaAffinity(LivingEntity p_44935_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.AQUA_AFFINITY, p_44935_) > 0;
    }

    public static boolean hasFrostWalker(LivingEntity p_44939_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.FROST_WALKER, p_44939_) > 0;
    }

    public static boolean hasSoulSpeed(LivingEntity p_44943_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.SOUL_SPEED, p_44943_) > 0;
    }

    public static boolean hasBindingCurse(ItemStack p_44921_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.BINDING_CURSE, p_44921_) > 0;
    }

    public static boolean hasVanishingCurse(ItemStack p_44925_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.VANISHING_CURSE, p_44925_) > 0;
    }

    public static boolean hasSilkTouch(ItemStack p_273444_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.SILK_TOUCH, p_273444_) > 0;
    }

    public static int getLoyalty(ItemStack p_44929_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.LOYALTY, p_44929_);
    }

    public static int getRiptide(ItemStack p_44933_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.RIPTIDE, p_44933_);
    }

    public static boolean hasChanneling(ItemStack p_44937_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.CHANNELING, p_44937_) > 0;
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> getRandomItemWith(Enchantment p_44907_, LivingEntity p_44908_) {
        return EnchantmentHelper.getRandomItemWith(p_44907_, p_44908_, p_44941_ -> true);
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> getRandomItemWith(Enchantment p_44840_, LivingEntity p_44841_, Predicate<ItemStack> p_44842_) {
        Map<EquipmentSlot, ItemStack> map = p_44840_.getSlotItems(p_44841_);
        if (map.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<EquipmentSlot, ItemStack> entry : map.entrySet()) {
            ItemStack itemstack = entry.getValue();
            if (itemstack.isEmpty() || EnchantmentHelper.getItemEnchantmentLevel(p_44840_, itemstack) <= 0 || !p_44842_.test(itemstack)) continue;
            list.add(entry);
        }
        return list.isEmpty() ? null : (Map.Entry)list.get(p_44841_.getRandom().nextInt(list.size()));
    }

    public static int getEnchantmentCost(RandomSource p_220288_, int p_220289_, int p_220290_, ItemStack p_220291_) {
        Item item = p_220291_.getItem();
        int i = p_220291_.getEnchantmentValue();
        if (i <= 0) {
            return 0;
        }
        if (p_220290_ > 15) {
            p_220290_ = 15;
        }
        int j = p_220288_.nextInt(8) + 1 + (p_220290_ >> 1) + p_220288_.nextInt(p_220290_ + 1);
        if (p_220289_ == 0) {
            return Math.max(j / 3, 1);
        }
        return p_220289_ == 1 ? j * 2 / 3 + 1 : Math.max(j, p_220290_ * 2);
    }

    public static ItemStack enchantItem(RandomSource p_220293_, ItemStack p_220294_, int p_220295_, boolean p_220296_) {
        List<EnchantmentInstance> list = EnchantmentHelper.selectEnchantment(p_220293_, p_220294_, p_220295_, p_220296_);
        boolean flag = p_220294_.is(Items.BOOK);
        if (flag) {
            p_220294_ = new ItemStack(Items.ENCHANTED_BOOK);
        }
        for (EnchantmentInstance enchantmentinstance : list) {
            if (flag) {
                EnchantedBookItem.addEnchantment(p_220294_, enchantmentinstance);
                continue;
            }
            p_220294_.enchant(enchantmentinstance.enchantment, enchantmentinstance.level);
        }
        return p_220294_;
    }

    public static List<EnchantmentInstance> selectEnchantment(RandomSource p_220298_, ItemStack p_220299_, int p_220300_, boolean p_220301_) {
        ArrayList list = Lists.newArrayList();
        Item item = p_220299_.getItem();
        int i = p_220299_.getEnchantmentValue();
        if (i <= 0) {
            return list;
        }
        p_220300_ += 1 + p_220298_.nextInt(i / 4 + 1) + p_220298_.nextInt(i / 4 + 1);
        float f = (p_220298_.nextFloat() + p_220298_.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentInstance> list1 = EnchantmentHelper.getAvailableEnchantmentResults(p_220300_ = Mth.clamp(Math.round((float)p_220300_ + (float)p_220300_ * f), 1, Integer.MAX_VALUE), p_220299_, p_220301_);
        if (!list1.isEmpty()) {
            WeightedRandom.getRandomItem(p_220298_, list1).ifPresent(list::add);
            while (p_220298_.nextInt(50) <= p_220300_) {
                if (!list.isEmpty()) {
                    EnchantmentHelper.filterCompatibleEnchantments(list1, (EnchantmentInstance)Util.lastOf(list));
                }
                if (list1.isEmpty()) break;
                WeightedRandom.getRandomItem(p_220298_, list1).ifPresent(list::add);
                p_220300_ /= 2;
            }
        }
        return list;
    }

    public static void filterCompatibleEnchantments(List<EnchantmentInstance> p_44863_, EnchantmentInstance p_44864_) {
        Iterator<EnchantmentInstance> iterator = p_44863_.iterator();
        while (iterator.hasNext()) {
            if (p_44864_.enchantment.isCompatibleWith(iterator.next().enchantment)) continue;
            iterator.remove();
        }
    }

    public static boolean isEnchantmentCompatible(Collection<Enchantment> p_44860_, Enchantment p_44861_) {
        for (Enchantment enchantment : p_44860_) {
            if (enchantment.isCompatibleWith(p_44861_)) continue;
            return false;
        }
        return true;
    }

    public static List<EnchantmentInstance> getAvailableEnchantmentResults(int p_44818_, ItemStack p_44819_, boolean p_44820_) {
        ArrayList list = Lists.newArrayList();
        Item item = p_44819_.getItem();
        boolean flag = p_44819_.is(Items.BOOK);
        block0: for (Enchantment enchantment : BuiltInRegistries.ENCHANTMENT) {
            if (enchantment.isTreasureOnly() && !p_44820_ || !enchantment.isDiscoverable() || !enchantment.canApplyAtEnchantingTable(p_44819_) && (!flag || !enchantment.isAllowedOnBooks())) continue;
            for (int i = enchantment.getMaxLevel(); i > enchantment.getMinLevel() - 1; --i) {
                if (p_44818_ < enchantment.getMinCost(i) || p_44818_ > enchantment.getMaxCost(i)) continue;
                list.add(new EnchantmentInstance(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    private static /* synthetic */ void lambda$runIterationOnItem$1(EnchantmentVisitor p_44851_, CompoundTag compoundtag, Enchantment p_182437_) {
        p_44851_.accept(p_182437_, EnchantmentHelper.getEnchantmentLevel(compoundtag));
    }

    @FunctionalInterface
    static interface EnchantmentVisitor {
        public void accept(Enchantment var1, int var2);
    }
}

