/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.world.ForgeChunkManager;

public class ForcedChunksSavedData
extends SavedData {
    public static final String FILE_ID = "chunks";
    private static final String TAG_FORCED = "Forced";
    private final LongSet chunks;
    private ForgeChunkManager.TicketTracker<BlockPos> blockForcedChunks = new ForgeChunkManager.TicketTracker();
    private ForgeChunkManager.TicketTracker<UUID> entityForcedChunks = new ForgeChunkManager.TicketTracker();

    private ForcedChunksSavedData(LongSet p_151482_) {
        this.chunks = p_151482_;
    }

    public ForcedChunksSavedData() {
        this((LongSet)new LongOpenHashSet());
    }

    public static ForcedChunksSavedData load(CompoundTag p_151484_) {
        ForcedChunksSavedData savedData = new ForcedChunksSavedData((LongSet)new LongOpenHashSet(p_151484_.getLongArray(TAG_FORCED)));
        ForgeChunkManager.readForgeForcedChunks(p_151484_, savedData.blockForcedChunks, savedData.entityForcedChunks);
        return savedData;
    }

    @Override
    public CompoundTag save(CompoundTag p_46120_) {
        p_46120_.putLongArray(TAG_FORCED, this.chunks.toLongArray());
        ForgeChunkManager.writeForgeForcedChunks(p_46120_, this.blockForcedChunks, this.entityForcedChunks);
        return p_46120_;
    }

    public LongSet getChunks() {
        return this.chunks;
    }

    public ForgeChunkManager.TicketTracker<BlockPos> getBlockForcedChunks() {
        return this.blockForcedChunks;
    }

    public ForgeChunkManager.TicketTracker<UUID> getEntityForcedChunks() {
        return this.entityForcedChunks;
    }
}

