/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.random.SimpleWeightedRandomList;

public record SpawnData(CompoundTag entityToSpawn, Optional<CustomSpawnRules> customSpawnRules) {
    public static final String ENTITY_TAG = "entity";
    public static final Codec<SpawnData> CODEC = RecordCodecBuilder.create(p_186571_ -> p_186571_.group((App)CompoundTag.CODEC.fieldOf(ENTITY_TAG).forGetter(p_186576_ -> p_186576_.entityToSpawn), (App)CustomSpawnRules.CODEC.optionalFieldOf("custom_spawn_rules").forGetter(p_186569_ -> p_186569_.customSpawnRules)).apply((Applicative)p_186571_, SpawnData::new));
    public static final Codec<SimpleWeightedRandomList<SpawnData>> LIST_CODEC = SimpleWeightedRandomList.wrappedCodecAllowingEmpty(CODEC);

    public SpawnData() {
        this(new CompoundTag(), Optional.empty());
    }

    public SpawnData {
        if (entityToSpawn.contains("id")) {
            ResourceLocation resourcelocation = ResourceLocation.tryParse(entityToSpawn.getString("id"));
            if (resourcelocation != null) {
                entityToSpawn.putString("id", resourcelocation.toString());
            } else {
                entityToSpawn.remove("id");
            }
        }
    }

    public CompoundTag getEntityToSpawn() {
        return this.entityToSpawn;
    }

    public Optional<CustomSpawnRules> getCustomSpawnRules() {
        return this.customSpawnRules;
    }

    public record CustomSpawnRules(InclusiveRange<Integer> blockLightLimit, InclusiveRange<Integer> skyLightLimit) {
        private static final InclusiveRange<Integer> LIGHT_RANGE = new InclusiveRange<Integer>(0, 15);
        public static final Codec<CustomSpawnRules> CODEC = RecordCodecBuilder.create(p_286217_ -> p_286217_.group((App)CustomSpawnRules.lightLimit("block_light_limit").forGetter(p_186600_ -> p_186600_.blockLightLimit), (App)CustomSpawnRules.lightLimit("sky_light_limit").forGetter(p_186595_ -> p_186595_.skyLightLimit)).apply((Applicative)p_286217_, CustomSpawnRules::new));

        private static DataResult<InclusiveRange<Integer>> checkLightBoundaries(InclusiveRange<Integer> p_186593_) {
            return !LIGHT_RANGE.contains(p_186593_) ? DataResult.error(() -> "Light values must be withing range " + String.valueOf(LIGHT_RANGE)) : DataResult.success(p_186593_);
        }

        private static MapCodec<InclusiveRange<Integer>> lightLimit(String p_286409_) {
            return ExtraCodecs.validate(InclusiveRange.INT.optionalFieldOf(p_286409_, LIGHT_RANGE), CustomSpawnRules::checkLightBoundaries);
        }
    }
}

