/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FlowerPotBlock
extends Block {
    private static final Map<Block, Block> POTTED_BY_CONTENT = Maps.newHashMap();
    public static final float AABB_SIZE = 3.0f;
    protected static final VoxelShape SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final Block content = null;
    private final Map<ResourceLocation, Supplier<? extends Block>> fullPots;
    private final Supplier<FlowerPotBlock> emptyPot;
    private final Supplier<? extends Block> flowerDelegate;

    @Deprecated
    public FlowerPotBlock(Block p_53528_, BlockBehaviour.Properties p_53529_) {
        this(Blocks.FLOWER_POT == null ? null : () -> (FlowerPotBlock)ForgeRegistries.BLOCKS.getDelegateOrThrow(Blocks.FLOWER_POT).get(), () -> (Block)ForgeRegistries.BLOCKS.getDelegateOrThrow(p_53528_).get(), p_53529_);
        if (Blocks.FLOWER_POT != null) {
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ForgeRegistries.BLOCKS.getKey(p_53528_), () -> this);
        }
    }

    public FlowerPotBlock(@Nullable Supplier<FlowerPotBlock> emptyPot, Supplier<? extends Block> p_53528_, BlockBehaviour.Properties properties) {
        super(properties);
        this.flowerDelegate = p_53528_;
        if (emptyPot == null) {
            this.fullPots = Maps.newHashMap();
            this.emptyPot = null;
        } else {
            this.fullPots = Collections.emptyMap();
            this.emptyPot = emptyPot;
        }
    }

    @Override
    public VoxelShape getShape(BlockState p_53556_, BlockGetter p_53557_, BlockPos p_53558_, CollisionContext p_53559_) {
        return SHAPE;
    }

    @Override
    public RenderShape getRenderShape(BlockState p_53554_) {
        return RenderShape.MODEL;
    }

    @Override
    public InteractionResult use(BlockState p_53540_, Level p_53541_, BlockPos p_53542_, Player p_53543_, InteractionHand p_53544_, BlockHitResult p_53545_) {
        boolean flag1;
        ItemStack itemstack = p_53543_.getItemInHand(p_53544_);
        Item item = itemstack.getItem();
        BlockState blockstate = (item instanceof BlockItem ? (Block)((Supplier)this.getEmptyPot().fullPots.getOrDefault(ForgeRegistries.BLOCKS.getKey(((BlockItem)item).getBlock()), ForgeRegistries.BLOCKS.getDelegateOrThrow(Blocks.AIR))).get() : Blocks.AIR).defaultBlockState();
        boolean flag = blockstate.is(Blocks.AIR);
        if (flag != (flag1 = this.isEmpty())) {
            if (flag1) {
                p_53541_.setBlock(p_53542_, blockstate, 3);
                p_53543_.awardStat(Stats.POT_FLOWER);
                if (!p_53543_.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            } else {
                ItemStack itemstack1 = new ItemStack(this.content);
                if (itemstack.isEmpty()) {
                    p_53543_.setItemInHand(p_53544_, itemstack1);
                } else if (!p_53543_.addItem(itemstack1)) {
                    p_53543_.drop(itemstack1, false);
                }
                p_53541_.setBlock(p_53542_, this.getEmptyPot().defaultBlockState(), 3);
            }
            p_53541_.gameEvent((Entity)p_53543_, GameEvent.BLOCK_CHANGE, p_53542_);
            return InteractionResult.sidedSuccess(p_53541_.isClientSide);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public ItemStack getCloneItemStack(BlockGetter p_53531_, BlockPos p_53532_, BlockState p_53533_) {
        return this.isEmpty() ? super.getCloneItemStack(p_53531_, p_53532_, p_53533_) : new ItemStack(this.content);
    }

    private boolean isEmpty() {
        return this.content == Blocks.AIR;
    }

    @Override
    public BlockState updateShape(BlockState p_53547_, Direction p_53548_, BlockState p_53549_, LevelAccessor p_53550_, BlockPos p_53551_, BlockPos p_53552_) {
        return p_53548_ == Direction.DOWN && !p_53547_.canSurvive(p_53550_, p_53551_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_53547_, p_53548_, p_53549_, p_53550_, p_53551_, p_53552_);
    }

    public Block getContent() {
        return this.flowerDelegate.get();
    }

    @Override
    public boolean isPathfindable(BlockState p_53535_, BlockGetter p_53536_, BlockPos p_53537_, PathComputationType p_53538_) {
        return false;
    }

    public FlowerPotBlock getEmptyPot() {
        return this.emptyPot == null ? this : this.emptyPot.get();
    }

    public void addPlant(ResourceLocation flower, Supplier<? extends Block> fullPot) {
        if (this.getEmptyPot() != this) {
            throw new IllegalArgumentException("Cannot add plant to non-empty pot: " + String.valueOf(this));
        }
        this.fullPots.put(flower, fullPot);
    }

    public Map<ResourceLocation, Supplier<? extends Block>> getFullPotsView() {
        return Collections.unmodifiableMap(this.fullPots);
    }
}

