/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.mojang.serialization.Codec;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;

public interface PositionSourceType<T extends PositionSource> {
    public static final PositionSourceType<BlockPositionSource> BLOCK = PositionSourceType.register("block", new BlockPositionSource.Type());
    public static final PositionSourceType<EntityPositionSource> ENTITY = PositionSourceType.register("entity", new EntityPositionSource.Type());

    public T read(FriendlyByteBuf var1);

    public void write(FriendlyByteBuf var1, T var2);

    public Codec<T> codec();

    public static <S extends PositionSourceType<T>, T extends PositionSource> S register(String p_157878_, S p_157879_) {
        return (S)Registry.register(BuiltInRegistries.POSITION_SOURCE_TYPE, p_157878_, p_157879_);
    }

    public static PositionSource fromNetwork(FriendlyByteBuf p_157886_) {
        ResourceLocation resourcelocation = p_157886_.readResourceLocation();
        return BuiltInRegistries.POSITION_SOURCE_TYPE.getOptional(resourcelocation).orElseThrow(() -> new IllegalArgumentException("Unknown position source type " + String.valueOf(resourcelocation))).read(p_157886_);
    }

    public static <T extends PositionSource> void toNetwork(T p_157875_, FriendlyByteBuf p_157876_) {
        p_157876_.writeResourceLocation(BuiltInRegistries.POSITION_SOURCE_TYPE.getKey(p_157875_.getType()));
        p_157875_.getType().write(p_157876_, p_157875_);
    }
}

