/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlackstoneReplaceProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockAgeProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.LavaSubmergedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class RuinedPortalPiece
extends TemplateStructurePiece {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float PROBABILITY_OF_GOLD_GONE = 0.3f;
    private static final float PROBABILITY_OF_MAGMA_INSTEAD_OF_NETHERRACK = 0.07f;
    private static final float PROBABILITY_OF_MAGMA_INSTEAD_OF_LAVA = 0.2f;
    private final VerticalPlacement verticalPlacement;
    private final Properties properties;

    public RuinedPortalPiece(StructureTemplateManager p_229105_, BlockPos p_229106_, VerticalPlacement p_229107_, Properties p_229108_, ResourceLocation p_229109_, StructureTemplate p_229110_, Rotation p_229111_, Mirror p_229112_, BlockPos p_229113_) {
        super(StructurePieceType.RUINED_PORTAL, 0, p_229105_, p_229109_, p_229109_.toString(), RuinedPortalPiece.makeSettings(p_229112_, p_229111_, p_229107_, p_229113_, p_229108_), p_229106_);
        this.verticalPlacement = p_229107_;
        this.properties = p_229108_;
    }

    public RuinedPortalPiece(StructureTemplateManager p_229115_, CompoundTag p_229116_) {
        super(StructurePieceType.RUINED_PORTAL, p_229116_, p_229115_, p_229188_ -> RuinedPortalPiece.makeSettings(p_229115_, p_229116_, p_229188_));
        this.verticalPlacement = VerticalPlacement.byName(p_229116_.getString("VerticalPlacement"));
        this.properties = (Properties)Properties.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_229116_.get("Properties"))).getOrThrow(true, arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext p_229158_, CompoundTag p_229159_) {
        super.addAdditionalSaveData(p_229158_, p_229159_);
        p_229159_.putString("Rotation", this.placeSettings.getRotation().name());
        p_229159_.putString("Mirror", this.placeSettings.getMirror().name());
        p_229159_.putString("VerticalPlacement", this.verticalPlacement.getName());
        Properties.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.properties).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_229177_ -> p_229159_.put("Properties", (Tag)p_229177_));
    }

    private static StructurePlaceSettings makeSettings(StructureTemplateManager p_229166_, CompoundTag p_229167_, ResourceLocation p_229168_) {
        StructureTemplate structuretemplate = p_229166_.getOrCreate(p_229168_);
        BlockPos blockpos = new BlockPos(structuretemplate.getSize().getX() / 2, 0, structuretemplate.getSize().getZ() / 2);
        return RuinedPortalPiece.makeSettings(Mirror.valueOf(p_229167_.getString("Mirror")), Rotation.valueOf(p_229167_.getString("Rotation")), VerticalPlacement.byName(p_229167_.getString("VerticalPlacement")), blockpos, (Properties)Properties.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_229167_.get("Properties"))).getOrThrow(true, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    private static StructurePlaceSettings makeSettings(Mirror p_229152_, Rotation p_229153_, VerticalPlacement p_229154_, BlockPos p_229155_, Properties p_229156_) {
        BlockIgnoreProcessor blockignoreprocessor = p_229156_.airPocket ? BlockIgnoreProcessor.STRUCTURE_BLOCK : BlockIgnoreProcessor.STRUCTURE_AND_AIR;
        ArrayList list = Lists.newArrayList();
        list.add(RuinedPortalPiece.getBlockReplaceRule(Blocks.GOLD_BLOCK, 0.3f, Blocks.AIR));
        list.add(RuinedPortalPiece.getLavaProcessorRule(p_229154_, p_229156_));
        if (!p_229156_.cold) {
            list.add(RuinedPortalPiece.getBlockReplaceRule(Blocks.NETHERRACK, 0.07f, Blocks.MAGMA_BLOCK));
        }
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings().setRotation(p_229153_).setMirror(p_229152_).setRotationPivot(p_229155_).addProcessor(blockignoreprocessor).addProcessor(new RuleProcessor(list)).addProcessor(new BlockAgeProcessor(p_229156_.mossiness)).addProcessor(new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE)).addProcessor(new LavaSubmergedBlockProcessor());
        if (p_229156_.replaceWithBlackstone) {
            structureplacesettings.addProcessor(BlackstoneReplaceProcessor.INSTANCE);
        }
        return structureplacesettings;
    }

    private static ProcessorRule getLavaProcessorRule(VerticalPlacement p_229163_, Properties p_229164_) {
        if (p_229163_ == VerticalPlacement.ON_OCEAN_FLOOR) {
            return RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, Blocks.MAGMA_BLOCK);
        }
        return p_229164_.cold ? RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, Blocks.NETHERRACK) : RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, 0.2f, Blocks.MAGMA_BLOCK);
    }

    @Override
    public void postProcess(WorldGenLevel p_229137_, StructureManager p_229138_, ChunkGenerator p_229139_, RandomSource p_229140_, BoundingBox p_229141_, ChunkPos p_229142_, BlockPos p_229143_) {
        BoundingBox boundingbox = this.template.getBoundingBox(this.placeSettings, this.templatePosition);
        if (p_229141_.isInside(boundingbox.getCenter())) {
            p_229141_.encapsulate(boundingbox);
            super.postProcess(p_229137_, p_229138_, p_229139_, p_229140_, p_229141_, p_229142_, p_229143_);
            this.spreadNetherrack(p_229140_, p_229137_);
            this.addNetherrackDripColumnsBelowPortal(p_229140_, p_229137_);
            if (this.properties.vines || this.properties.overgrown) {
                BlockPos.betweenClosedStream(this.getBoundingBox()).forEach(p_229127_ -> {
                    if (this.properties.vines) {
                        this.maybeAddVines(p_229140_, p_229137_, (BlockPos)p_229127_);
                    }
                    if (this.properties.overgrown) {
                        this.maybeAddLeavesAbove(p_229140_, p_229137_, (BlockPos)p_229127_);
                    }
                });
            }
        }
    }

    @Override
    protected void handleDataMarker(String p_229170_, BlockPos p_229171_, ServerLevelAccessor p_229172_, RandomSource p_229173_, BoundingBox p_229174_) {
    }

    private void maybeAddVines(RandomSource p_229121_, LevelAccessor p_229122_, BlockPos p_229123_) {
        Direction direction;
        BlockPos blockpos;
        BlockState blockstate1;
        BlockState blockstate = p_229122_.getBlockState(p_229123_);
        if (!blockstate.isAir() && !blockstate.is(Blocks.VINE) && (blockstate1 = p_229122_.getBlockState(blockpos = p_229123_.relative(direction = RuinedPortalPiece.getRandomHorizontalDirection(p_229121_)))).isAir() && Block.isFaceFull(blockstate.getCollisionShape(p_229122_, p_229123_), direction)) {
            BooleanProperty booleanproperty = VineBlock.getPropertyForFace(direction.getOpposite());
            p_229122_.setBlock(blockpos, (BlockState)Blocks.VINE.defaultBlockState().setValue(booleanproperty, true), 3);
        }
    }

    private void maybeAddLeavesAbove(RandomSource p_229182_, LevelAccessor p_229183_, BlockPos p_229184_) {
        if (p_229182_.nextFloat() < 0.5f && p_229183_.getBlockState(p_229184_).is(Blocks.NETHERRACK) && p_229183_.getBlockState(p_229184_.above()).isAir()) {
            p_229183_.setBlock(p_229184_.above(), (BlockState)Blocks.JUNGLE_LEAVES.defaultBlockState().setValue(LeavesBlock.PERSISTENT, true), 3);
        }
    }

    private void addNetherrackDripColumnsBelowPortal(RandomSource p_229118_, LevelAccessor p_229119_) {
        for (int i = this.boundingBox.minX() + 1; i < this.boundingBox.maxX(); ++i) {
            for (int j = this.boundingBox.minZ() + 1; j < this.boundingBox.maxZ(); ++j) {
                BlockPos blockpos = new BlockPos(i, this.boundingBox.minY(), j);
                if (!p_229119_.getBlockState(blockpos).is(Blocks.NETHERRACK)) continue;
                this.addNetherrackDripColumn(p_229118_, p_229119_, blockpos.below());
            }
        }
    }

    private void addNetherrackDripColumn(RandomSource p_229190_, LevelAccessor p_229191_, BlockPos p_229192_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_229192_.mutable();
        this.placeNetherrackOrMagma(p_229190_, p_229191_, blockpos$mutableblockpos);
        for (int i = 8; i > 0 && p_229190_.nextFloat() < 0.5f; --i) {
            blockpos$mutableblockpos.move(Direction.DOWN);
            this.placeNetherrackOrMagma(p_229190_, p_229191_, blockpos$mutableblockpos);
        }
    }

    private void spreadNetherrack(RandomSource p_229179_, LevelAccessor p_229180_) {
        boolean flag = this.verticalPlacement == VerticalPlacement.ON_LAND_SURFACE || this.verticalPlacement == VerticalPlacement.ON_OCEAN_FLOOR;
        BlockPos blockpos = this.boundingBox.getCenter();
        int i = blockpos.getX();
        int j = blockpos.getZ();
        float[] afloat = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int k = afloat.length;
        int l = (this.boundingBox.getXSpan() + this.boundingBox.getZSpan()) / 2;
        int i1 = p_229179_.nextInt(Math.max(1, 8 - l / 2));
        int j1 = 3;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = BlockPos.ZERO.mutable();
        for (int k1 = i - k; k1 <= i + k; ++k1) {
            for (int l1 = j - k; l1 <= j + k; ++l1) {
                int i2 = Math.abs(k1 - i) + Math.abs(l1 - j);
                int j2 = Math.max(0, i2 + i1);
                if (j2 >= k) continue;
                float f = afloat[j2];
                if (!(p_229179_.nextDouble() < (double)f)) continue;
                int k2 = RuinedPortalPiece.getSurfaceY(p_229180_, k1, l1, this.verticalPlacement);
                int l2 = flag ? k2 : Math.min(this.boundingBox.minY(), k2);
                blockpos$mutableblockpos.set(k1, l2, l1);
                if (Math.abs(l2 - this.boundingBox.minY()) > 3 || !this.canBlockBeReplacedByNetherrackOrMagma(p_229180_, blockpos$mutableblockpos)) continue;
                this.placeNetherrackOrMagma(p_229179_, p_229180_, blockpos$mutableblockpos);
                if (this.properties.overgrown) {
                    this.maybeAddLeavesAbove(p_229179_, p_229180_, blockpos$mutableblockpos);
                }
                this.addNetherrackDripColumn(p_229179_, p_229180_, (BlockPos)blockpos$mutableblockpos.below());
            }
        }
    }

    private boolean canBlockBeReplacedByNetherrackOrMagma(LevelAccessor p_229134_, BlockPos p_229135_) {
        BlockState blockstate = p_229134_.getBlockState(p_229135_);
        return !blockstate.is(Blocks.AIR) && !blockstate.is(Blocks.OBSIDIAN) && !blockstate.is(BlockTags.FEATURES_CANNOT_REPLACE) && (this.verticalPlacement == VerticalPlacement.IN_NETHER || !blockstate.is(Blocks.LAVA));
    }

    private void placeNetherrackOrMagma(RandomSource p_229194_, LevelAccessor p_229195_, BlockPos p_229196_) {
        if (!this.properties.cold && p_229194_.nextFloat() < 0.07f) {
            p_229195_.setBlock(p_229196_, Blocks.MAGMA_BLOCK.defaultBlockState(), 3);
        } else {
            p_229195_.setBlock(p_229196_, Blocks.NETHERRACK.defaultBlockState(), 3);
        }
    }

    private static int getSurfaceY(LevelAccessor p_229129_, int p_229130_, int p_229131_, VerticalPlacement p_229132_) {
        return p_229129_.getHeight(RuinedPortalPiece.getHeightMapType(p_229132_), p_229130_, p_229131_) - 1;
    }

    public static Heightmap.Types getHeightMapType(VerticalPlacement p_229161_) {
        return p_229161_ == VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
    }

    private static ProcessorRule getBlockReplaceRule(Block p_229145_, float p_229146_, Block p_229147_) {
        return new ProcessorRule(new RandomBlockMatchTest(p_229145_, p_229146_), AlwaysTrueTest.INSTANCE, p_229147_.defaultBlockState());
    }

    private static ProcessorRule getBlockReplaceRule(Block p_229149_, Block p_229150_) {
        return new ProcessorRule(new BlockMatchTest(p_229149_), AlwaysTrueTest.INSTANCE, p_229150_.defaultBlockState());
    }

    public static enum VerticalPlacement implements StringRepresentable
    {
        ON_LAND_SURFACE("on_land_surface"),
        PARTLY_BURIED("partly_buried"),
        ON_OCEAN_FLOOR("on_ocean_floor"),
        IN_MOUNTAIN("in_mountain"),
        UNDERGROUND("underground"),
        IN_NETHER("in_nether");

        public static final StringRepresentable.EnumCodec<VerticalPlacement> CODEC;
        private final String name;

        private VerticalPlacement(String p_229240_) {
            this.name = p_229240_;
        }

        public String getName() {
            return this.name;
        }

        public static VerticalPlacement byName(String p_229243_) {
            return CODEC.byName(p_229243_);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(VerticalPlacement::values);
        }
    }

    public static class Properties {
        public static final Codec<Properties> CODEC = RecordCodecBuilder.create(p_229214_ -> p_229214_.group((App)Codec.BOOL.fieldOf("cold").forGetter(p_229226_ -> p_229226_.cold), (App)Codec.FLOAT.fieldOf("mossiness").forGetter(p_229224_ -> Float.valueOf(p_229224_.mossiness)), (App)Codec.BOOL.fieldOf("air_pocket").forGetter(p_229222_ -> p_229222_.airPocket), (App)Codec.BOOL.fieldOf("overgrown").forGetter(p_229220_ -> p_229220_.overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(p_229218_ -> p_229218_.vines), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(p_229216_ -> p_229216_.replaceWithBlackstone)).apply((Applicative)p_229214_, Properties::new));
        public boolean cold;
        public float mossiness;
        public boolean airPocket;
        public boolean overgrown;
        public boolean vines;
        public boolean replaceWithBlackstone;

        public Properties() {
        }

        public Properties(boolean p_229207_, float p_229208_, boolean p_229209_, boolean p_229210_, boolean p_229211_, boolean p_229212_) {
            this.cold = p_229207_;
            this.mossiness = p_229208_;
            this.airPocket = p_229209_;
            this.overgrown = p_229210_;
            this.vines = p_229211_;
            this.replaceWithBlackstone = p_229212_;
        }
    }
}

