/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RuinedPortalStructure
extends Structure {
    private static final String[] STRUCTURE_LOCATION_PORTALS = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] STRUCTURE_LOCATION_GIANT_PORTALS = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private static final float PROBABILITY_OF_GIANT_PORTAL = 0.05f;
    private static final int MIN_Y_INDEX = 15;
    private final List<Setup> setups;
    public static final Codec<RuinedPortalStructure> CODEC = RecordCodecBuilder.create(p_229304_ -> p_229304_.group(RuinedPortalStructure.settingsCodec(p_229304_), (App)ExtraCodecs.nonEmptyList(Setup.CODEC.listOf()).fieldOf("setups").forGetter(p_229299_ -> p_229299_.setups)).apply((Applicative)p_229304_, RuinedPortalStructure::new));

    public RuinedPortalStructure(Structure.StructureSettings p_229260_, List<Setup> p_229261_) {
        super(p_229260_);
        this.setups = p_229261_;
    }

    public RuinedPortalStructure(Structure.StructureSettings p_229257_, Setup p_229258_) {
        this(p_229257_, List.of(p_229258_));
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext p_229285_) {
        RuinedPortalPiece.Properties ruinedportalpiece$properties = new RuinedPortalPiece.Properties();
        WorldgenRandom worldgenrandom = p_229285_.random();
        Setup ruinedportalstructure$setup = null;
        if (this.setups.size() > 1) {
            float f = 0.0f;
            for (Setup setup : this.setups) {
                f += setup.weight();
            }
            float f1 = worldgenrandom.nextFloat();
            for (Setup ruinedportalstructure$setup2 : this.setups) {
                if (!((f1 -= ruinedportalstructure$setup2.weight() / f) < 0.0f)) continue;
                ruinedportalstructure$setup = ruinedportalstructure$setup2;
                break;
            }
        } else {
            ruinedportalstructure$setup = this.setups.get(0);
        }
        if (ruinedportalstructure$setup == null) {
            throw new IllegalStateException();
        }
        Setup ruinedportalstructure$setup3 = ruinedportalstructure$setup;
        ruinedportalpiece$properties.airPocket = RuinedPortalStructure.sample(worldgenrandom, ruinedportalstructure$setup3.airPocketProbability());
        ruinedportalpiece$properties.mossiness = ruinedportalstructure$setup3.mossiness();
        ruinedportalpiece$properties.overgrown = ruinedportalstructure$setup3.overgrown();
        ruinedportalpiece$properties.vines = ruinedportalstructure$setup3.vines();
        ruinedportalpiece$properties.replaceWithBlackstone = ruinedportalstructure$setup3.replaceWithBlackstone();
        ResourceLocation resourcelocation = worldgenrandom.nextFloat() < 0.05f ? new ResourceLocation(STRUCTURE_LOCATION_GIANT_PORTALS[worldgenrandom.nextInt(STRUCTURE_LOCATION_GIANT_PORTALS.length)]) : new ResourceLocation(STRUCTURE_LOCATION_PORTALS[worldgenrandom.nextInt(STRUCTURE_LOCATION_PORTALS.length)]);
        StructureTemplate structureTemplate = p_229285_.structureTemplateManager().getOrCreate(resourcelocation);
        Rotation rotation = Util.getRandom(Rotation.values(), (RandomSource)worldgenrandom);
        Mirror mirror = worldgenrandom.nextFloat() < 0.5f ? Mirror.NONE : Mirror.FRONT_BACK;
        BlockPos blockpos = new BlockPos(structureTemplate.getSize().getX() / 2, 0, structureTemplate.getSize().getZ() / 2);
        ChunkGenerator chunkgenerator = p_229285_.chunkGenerator();
        LevelHeightAccessor levelheightaccessor = p_229285_.heightAccessor();
        RandomState randomstate = p_229285_.randomState();
        BlockPos blockpos1 = p_229285_.chunkPos().getWorldPosition();
        BoundingBox boundingbox = structureTemplate.getBoundingBox(blockpos1, rotation, blockpos, mirror);
        BlockPos blockpos2 = boundingbox.getCenter();
        int i = chunkgenerator.getBaseHeight(blockpos2.getX(), blockpos2.getZ(), RuinedPortalPiece.getHeightMapType(ruinedportalstructure$setup3.placement()), levelheightaccessor, randomstate) - 1;
        int j = RuinedPortalStructure.findSuitableY(worldgenrandom, chunkgenerator, ruinedportalstructure$setup3.placement(), ruinedportalpiece$properties.airPocket, i, boundingbox.getYSpan(), boundingbox, levelheightaccessor, randomstate);
        BlockPos blockpos3 = new BlockPos(blockpos1.getX(), j, blockpos1.getZ());
        return Optional.of(new Structure.GenerationStub(blockpos3, p_229297_ -> {
            if (ruinedportalstructure$setup3.canBeCold()) {
                ruinedportalpiece$properties.cold = RuinedPortalStructure.isCold(blockpos3, p_229285_.chunkGenerator().getBiomeSource().getNoiseBiome(QuartPos.fromBlock(blockpos3.getX()), QuartPos.fromBlock(blockpos3.getY()), QuartPos.fromBlock(blockpos3.getZ()), randomstate.sampler()));
            }
            p_229297_.addPiece(new RuinedPortalPiece(p_229285_.structureTemplateManager(), blockpos3, ruinedportalstructure$setup3.placement(), ruinedportalpiece$properties, resourcelocation, structuretemplate, rotation, mirror, blockpos));
        }));
    }

    private static boolean sample(WorldgenRandom p_229282_, float p_229283_) {
        if (p_229283_ == 0.0f) {
            return false;
        }
        if (p_229283_ == 1.0f) {
            return true;
        }
        return p_229282_.nextFloat() < p_229283_;
    }

    private static boolean isCold(BlockPos p_229301_, Holder<Biome> p_229302_) {
        return p_229302_.value().coldEnoughToSnow(p_229301_);
    }

    private static int findSuitableY(RandomSource p_229267_, ChunkGenerator p_229268_, RuinedPortalPiece.VerticalPlacement p_229269_, boolean p_229270_, int p_229271_, int p_229272_, BoundingBox p_229273_, LevelHeightAccessor p_229274_, RandomState p_229275_) {
        int l;
        int j = p_229274_.getMinBuildHeight() + 15;
        if (p_229269_ == RuinedPortalPiece.VerticalPlacement.IN_NETHER) {
            i = p_229270_ ? Mth.randomBetweenInclusive(p_229267_, 32, 100) : (p_229267_.nextFloat() < 0.5f ? Mth.randomBetweenInclusive(p_229267_, 27, 29) : Mth.randomBetweenInclusive(p_229267_, 29, 100));
        } else if (p_229269_ == RuinedPortalPiece.VerticalPlacement.IN_MOUNTAIN) {
            int k = p_229271_ - p_229272_;
            i = RuinedPortalStructure.getRandomWithinInterval(p_229267_, 70, k);
        } else if (p_229269_ == RuinedPortalPiece.VerticalPlacement.UNDERGROUND) {
            int j1 = p_229271_ - p_229272_;
            i = RuinedPortalStructure.getRandomWithinInterval(p_229267_, j, j1);
        } else {
            i = p_229269_ == RuinedPortalPiece.VerticalPlacement.PARTLY_BURIED ? p_229271_ - p_229272_ + Mth.randomBetweenInclusive(p_229267_, 2, 8) : p_229271_;
        }
        ImmutableList list1 = ImmutableList.of((Object)new BlockPos(p_229273_.minX(), 0, p_229273_.minZ()), (Object)new BlockPos(p_229273_.maxX(), 0, p_229273_.minZ()), (Object)new BlockPos(p_229273_.minX(), 0, p_229273_.maxZ()), (Object)new BlockPos(p_229273_.maxX(), 0, p_229273_.maxZ()));
        List list = list1.stream().map(p_229280_ -> p_229268_.getBaseColumn(p_229280_.getX(), p_229280_.getZ(), p_229274_, p_229275_)).collect(Collectors.toList());
        Heightmap.Types heightmap$types = p_229269_ == RuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
        for (l = i; l > j; --l) {
            int i1 = 0;
            for (NoiseColumn noisecolumn : list) {
                BlockState blockstate = noisecolumn.getBlock(l);
                if (!heightmap$types.isOpaque().test(blockstate) || ++i1 != 3) continue;
                return l;
            }
        }
        return l;
    }

    private static int getRandomWithinInterval(RandomSource p_229263_, int p_229264_, int p_229265_) {
        return p_229264_ < p_229265_ ? Mth.randomBetweenInclusive(p_229263_, p_229264_, p_229265_) : p_229265_;
    }

    @Override
    public StructureType<?> type() {
        return StructureType.RUINED_PORTAL;
    }

    public record Setup(RuinedPortalPiece.VerticalPlacement placement, float airPocketProbability, float mossiness, boolean overgrown, boolean vines, boolean canBeCold, boolean replaceWithBlackstone, float weight) {
        public static final Codec<Setup> CODEC = RecordCodecBuilder.create(p_229327_ -> p_229327_.group((App)RuinedPortalPiece.VerticalPlacement.CODEC.fieldOf("placement").forGetter(Setup::placement), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("air_pocket_probability").forGetter(Setup::airPocketProbability), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("mossiness").forGetter(Setup::mossiness), (App)Codec.BOOL.fieldOf("overgrown").forGetter(Setup::overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(Setup::vines), (App)Codec.BOOL.fieldOf("can_be_cold").forGetter(Setup::canBeCold), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(Setup::replaceWithBlackstone), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("weight").forGetter(Setup::weight)).apply((Applicative)p_229327_, Setup::new));
    }
}

