/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.BlockLightSectionStorage;
import net.minecraft.world.level.lighting.LightEngine;

public final class BlockLightEngine
extends LightEngine<BlockLightSectionStorage.BlockDataLayerStorageMap, BlockLightSectionStorage> {
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();

    public BlockLightEngine(LightChunkGetter p_75492_) {
        this(p_75492_, new BlockLightSectionStorage(p_75492_));
    }

    @VisibleForTesting
    public BlockLightEngine(LightChunkGetter p_278252_, BlockLightSectionStorage p_278255_) {
        super(p_278252_, p_278255_);
    }

    @Override
    protected void checkNode(long p_285169_) {
        long i = SectionPos.blockToSection(p_285169_);
        if (((BlockLightSectionStorage)this.storage).storingLightForSection(i)) {
            int k;
            BlockState blockstate = this.getState(this.mutablePos.set(p_285169_));
            int j = this.getEmission(p_285169_, blockstate);
            if (j < (k = ((BlockLightSectionStorage)this.storage).getStoredLevel(p_285169_))) {
                ((BlockLightSectionStorage)this.storage).setStoredLevel(p_285169_, 0);
                this.enqueueDecrease(p_285169_, LightEngine.QueueEntry.decreaseAllDirections(k));
            } else {
                this.enqueueDecrease(p_285169_, PULL_LIGHT_IN_ENTRY);
            }
            if (j > 0) {
                this.enqueueIncrease(p_285169_, LightEngine.QueueEntry.increaseLightFromEmission(j, BlockLightEngine.isEmptyShape(blockstate)));
            }
        }
    }

    @Override
    protected void propagateIncrease(long p_285500_, long p_285410_, int p_285492_) {
        BlockState blockstate = null;
        for (Direction direction : PROPAGATION_DIRECTIONS) {
            int j;
            int k;
            long i;
            if (!LightEngine.QueueEntry.shouldPropagateInDirection(p_285410_, direction) || !((BlockLightSectionStorage)this.storage).storingLightForSection(SectionPos.blockToSection(i = BlockPos.offset(p_285500_, direction))) || (k = p_285492_ - 1) <= (j = ((BlockLightSectionStorage)this.storage).getStoredLevel(i))) continue;
            this.mutablePos.set(i);
            BlockState blockstate1 = this.getState(this.mutablePos);
            int l = p_285492_ - this.getOpacity(blockstate1, this.mutablePos);
            if (l <= j) continue;
            if (blockstate == null) {
                BlockState blockState = blockstate = LightEngine.QueueEntry.isFromEmptyShape(p_285410_) ? Blocks.AIR.defaultBlockState() : this.getState(this.mutablePos.set(p_285500_));
            }
            if (this.shapeOccludes(p_285500_, blockstate, i, blockstate1, direction)) continue;
            ((BlockLightSectionStorage)this.storage).setStoredLevel(i, l);
            if (l <= 1) continue;
            this.enqueueIncrease(i, LightEngine.QueueEntry.increaseSkipOneDirection(l, BlockLightEngine.isEmptyShape(blockstate1), direction.getOpposite()));
        }
    }

    @Override
    protected void propagateDecrease(long p_285435_, long p_285230_) {
        int i = LightEngine.QueueEntry.getFromLevel(p_285230_);
        for (Direction direction : PROPAGATION_DIRECTIONS) {
            int k;
            long j;
            if (!LightEngine.QueueEntry.shouldPropagateInDirection(p_285230_, direction) || !((BlockLightSectionStorage)this.storage).storingLightForSection(SectionPos.blockToSection(j = BlockPos.offset(p_285435_, direction))) || (k = ((BlockLightSectionStorage)this.storage).getStoredLevel(j)) == 0) continue;
            if (k <= i - 1) {
                BlockState blockstate = this.getState(this.mutablePos.set(j));
                int l = this.getEmission(j, blockstate);
                ((BlockLightSectionStorage)this.storage).setStoredLevel(j, 0);
                if (l < k) {
                    this.enqueueDecrease(j, LightEngine.QueueEntry.decreaseSkipOneDirection(k, direction.getOpposite()));
                }
                if (l <= 0) continue;
                this.enqueueIncrease(j, LightEngine.QueueEntry.increaseLightFromEmission(l, BlockLightEngine.isEmptyShape(blockstate)));
                continue;
            }
            this.enqueueIncrease(j, LightEngine.QueueEntry.increaseOnlyOneDirection(k, false, direction.getOpposite()));
        }
    }

    private int getEmission(long p_285243_, BlockState p_284973_) {
        int i = p_284973_.getLightEmission(this.chunkSource.getLevel(), this.mutablePos);
        return i > 0 && ((BlockLightSectionStorage)this.storage).lightOnInSection(SectionPos.blockToSection(p_285243_)) ? i : 0;
    }

    @Override
    public void propagateLightSources(ChunkPos p_285274_) {
        this.setLightEnabled(p_285274_, true);
        LightChunk lightchunk = this.chunkSource.getChunkForLighting(p_285274_.x, p_285274_.z);
        if (lightchunk != null) {
            lightchunk.findBlockLightSources((p_285266_, p_285452_) -> {
                int i = p_285452_.getLightEmission(this.chunkSource.getLevel(), (BlockPos)p_285266_);
                this.enqueueIncrease(p_285266_.asLong(), LightEngine.QueueEntry.increaseLightFromEmission(i, BlockLightEngine.isEmptyShape(p_285452_)));
            });
        }
    }
}

