/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.DataLayerStorageMap;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;

public class SkyLightSectionStorage
extends LayerLightSectionStorage<SkyDataLayerStorageMap> {
    protected SkyLightSectionStorage(LightChunkGetter p_75868_) {
        super(LightLayer.SKY, p_75868_, new SkyDataLayerStorageMap((Long2ObjectOpenHashMap<DataLayer>)new Long2ObjectOpenHashMap(), new Long2IntOpenHashMap(), Integer.MAX_VALUE));
    }

    @Override
    protected int getLightValue(long p_75880_) {
        return this.getLightValue(p_75880_, false);
    }

    protected int getLightValue(long p_164458_, boolean p_164459_) {
        long i = SectionPos.blockToSection(p_164458_);
        int j = SectionPos.y(i);
        SkyDataLayerStorageMap skylightsectionstorage$skydatalayerstoragemap = p_164459_ ? (SkyDataLayerStorageMap)this.updatingSectionData : (SkyDataLayerStorageMap)this.visibleSectionData;
        int k = skylightsectionstorage$skydatalayerstoragemap.topSections.get(SectionPos.getZeroNode(i));
        if (k != skylightsectionstorage$skydatalayerstoragemap.currentLowestY && j < k) {
            DataLayer datalayer = this.getDataLayer(skylightsectionstorage$skydatalayerstoragemap, i);
            if (datalayer == null) {
                p_164458_ = BlockPos.getFlatIndex(p_164458_);
                while (datalayer == null) {
                    if (++j >= k) {
                        return 15;
                    }
                    i = SectionPos.offset(i, Direction.UP);
                    datalayer = this.getDataLayer(skylightsectionstorage$skydatalayerstoragemap, i);
                }
            }
            return datalayer.get(SectionPos.sectionRelative(BlockPos.getX(p_164458_)), SectionPos.sectionRelative(BlockPos.getY(p_164458_)), SectionPos.sectionRelative(BlockPos.getZ(p_164458_)));
        }
        return p_164459_ && !this.lightOnInSection(i) ? 0 : 15;
    }

    @Override
    protected void onNodeAdded(long p_75885_) {
        long j;
        int k;
        int i = SectionPos.y(p_75885_);
        if (((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY > i) {
            ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY = i;
            ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.defaultReturnValue(((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY);
        }
        if ((k = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(j = SectionPos.getZeroNode(p_75885_))) < i + 1) {
            ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.put(j, i + 1);
        }
    }

    @Override
    protected void onNodeRemoved(long p_75887_) {
        long i = SectionPos.getZeroNode(p_75887_);
        int j = SectionPos.y(p_75887_);
        if (((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(i) == j + 1) {
            long k = p_75887_;
            while (!this.storingLightForSection(k) && this.hasLightDataAtOrBelow(j)) {
                --j;
                k = SectionPos.offset(k, Direction.DOWN);
            }
            if (this.storingLightForSection(k)) {
                ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.put(i, j + 1);
            } else {
                ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.remove(i);
            }
        }
    }

    @Override
    protected DataLayer createDataLayer(long p_75883_) {
        DataLayer datalayer = (DataLayer)this.queuedSections.get(p_75883_);
        if (datalayer != null) {
            return datalayer;
        }
        int i = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(SectionPos.getZeroNode(p_75883_));
        if (i != ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY && SectionPos.y(p_75883_) < i) {
            DataLayer datalayer1;
            long j = SectionPos.offset(p_75883_, Direction.UP);
            while ((datalayer1 = this.getDataLayer(j, true)) == null) {
                j = SectionPos.offset(j, Direction.UP);
            }
            return SkyLightSectionStorage.repeatFirstLayer(datalayer1);
        }
        return this.lightOnInSection(p_75883_) ? new DataLayer(15) : new DataLayer();
    }

    private static DataLayer repeatFirstLayer(DataLayer p_182513_) {
        if (p_182513_.isDefinitelyHomogenous()) {
            return p_182513_.copy();
        }
        byte[] abyte = p_182513_.getData();
        byte[] abyte1 = new byte[2048];
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(abyte, 0, abyte1, i * 128, 128);
        }
        return new DataLayer(abyte1);
    }

    protected boolean hasLightDataAtOrBelow(int p_278270_) {
        return p_278270_ >= ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY;
    }

    protected boolean isAboveData(long p_75891_) {
        long i = SectionPos.getZeroNode(p_75891_);
        int j = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(i);
        return j == ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY || SectionPos.y(p_75891_) >= j;
    }

    protected int getTopSectionY(long p_285094_) {
        return ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(p_285094_);
    }

    protected int getBottomSectionY() {
        return ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY;
    }

    protected static final class SkyDataLayerStorageMap
    extends DataLayerStorageMap<SkyDataLayerStorageMap> {
        int currentLowestY;
        final Long2IntOpenHashMap topSections;

        public SkyDataLayerStorageMap(Long2ObjectOpenHashMap<DataLayer> p_75903_, Long2IntOpenHashMap p_75904_, int p_75905_) {
            super(p_75903_);
            this.topSections = p_75904_;
            p_75904_.defaultReturnValue(p_75905_);
            this.currentLowestY = p_75905_;
        }

        @Override
        public SkyDataLayerStorageMap copy() {
            return new SkyDataLayerStorageMap((Long2ObjectOpenHashMap<DataLayer>)this.map.clone(), this.topSections.clone(), this.currentLowestY);
        }
    }
}

