/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;

public class FlyNodeEvaluator
extends WalkNodeEvaluator {
    private final Long2ObjectMap<BlockPathTypes> pathTypeByPosCache = new Long2ObjectOpenHashMap();
    private static final float SMALL_MOB_INFLATED_START_NODE_BOUNDING_BOX = 1.5f;
    private static final int MAX_START_NODE_CANDIDATES = 10;

    @Override
    public void prepare(PathNavigationRegion p_77261_, Mob p_77262_) {
        super.prepare(p_77261_, p_77262_);
        this.pathTypeByPosCache.clear();
        p_77262_.onPathfindingStart();
    }

    @Override
    public void done() {
        this.mob.onPathfindingDone();
        this.pathTypeByPosCache.clear();
        super.done();
    }

    @Override
    public Node getStart() {
        BlockPos blockpos1;
        int i;
        if (this.canFloat() && this.mob.isInWater()) {
            i = this.mob.getBlockY();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(this.mob.getX(), (double)i, this.mob.getZ());
            BlockState blockstate = this.level.getBlockState(blockpos$mutableblockpos);
            while (blockstate.is(Blocks.WATER)) {
                blockpos$mutableblockpos.set(this.mob.getX(), (double)(++i), this.mob.getZ());
                blockstate = this.level.getBlockState(blockpos$mutableblockpos);
            }
        } else {
            i = Mth.floor(this.mob.getY() + 0.5);
        }
        if (!this.canStartAt(blockpos1 = BlockPos.containing(this.mob.getX(), i, this.mob.getZ()))) {
            for (BlockPos blockpos : this.iteratePathfindingStartNodeCandidatePositions(this.mob)) {
                if (!this.canStartAt(blockpos)) continue;
                return super.getStartNode(blockpos);
            }
        }
        return super.getStartNode(blockpos1);
    }

    @Override
    protected boolean canStartAt(BlockPos p_262645_) {
        BlockPathTypes blockpathtypes = this.getBlockPathType(this.mob, p_262645_);
        return this.mob.getPathfindingMalus(blockpathtypes) >= 0.0f;
    }

    @Override
    public Target getGoal(double p_77229_, double p_77230_, double p_77231_) {
        return this.getTargetFromNode(this.getNode(Mth.floor(p_77229_), Mth.floor(p_77230_), Mth.floor(p_77231_)));
    }

    @Override
    public int getNeighbors(Node[] p_77266_, Node p_77267_) {
        Node node25;
        Node node24;
        Node node23;
        Node node22;
        Node node21;
        Node node20;
        Node node19;
        Node node18;
        Node node17;
        Node node16;
        Node node15;
        Node node14;
        Node node13;
        Node node12;
        Node node11;
        Node node10;
        Node node9;
        Node node8;
        Node node7;
        Node node6;
        Node node5;
        Node node4;
        Node node3;
        Node node2;
        Node node1;
        int i = 0;
        Node node = this.findAcceptedNode(p_77267_.x, p_77267_.y, p_77267_.z + 1);
        if (this.isOpen(node)) {
            p_77266_[i++] = node;
        }
        if (this.isOpen(node1 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y, p_77267_.z))) {
            p_77266_[i++] = node1;
        }
        if (this.isOpen(node2 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y, p_77267_.z))) {
            p_77266_[i++] = node2;
        }
        if (this.isOpen(node3 = this.findAcceptedNode(p_77267_.x, p_77267_.y, p_77267_.z - 1))) {
            p_77266_[i++] = node3;
        }
        if (this.isOpen(node4 = this.findAcceptedNode(p_77267_.x, p_77267_.y + 1, p_77267_.z))) {
            p_77266_[i++] = node4;
        }
        if (this.isOpen(node5 = this.findAcceptedNode(p_77267_.x, p_77267_.y - 1, p_77267_.z))) {
            p_77266_[i++] = node5;
        }
        if (this.isOpen(node6 = this.findAcceptedNode(p_77267_.x, p_77267_.y + 1, p_77267_.z + 1)) && this.hasMalus(node) && this.hasMalus(node4)) {
            p_77266_[i++] = node6;
        }
        if (this.isOpen(node7 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y + 1, p_77267_.z)) && this.hasMalus(node1) && this.hasMalus(node4)) {
            p_77266_[i++] = node7;
        }
        if (this.isOpen(node8 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y + 1, p_77267_.z)) && this.hasMalus(node2) && this.hasMalus(node4)) {
            p_77266_[i++] = node8;
        }
        if (this.isOpen(node9 = this.findAcceptedNode(p_77267_.x, p_77267_.y + 1, p_77267_.z - 1)) && this.hasMalus(node3) && this.hasMalus(node4)) {
            p_77266_[i++] = node9;
        }
        if (this.isOpen(node10 = this.findAcceptedNode(p_77267_.x, p_77267_.y - 1, p_77267_.z + 1)) && this.hasMalus(node) && this.hasMalus(node5)) {
            p_77266_[i++] = node10;
        }
        if (this.isOpen(node11 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y - 1, p_77267_.z)) && this.hasMalus(node1) && this.hasMalus(node5)) {
            p_77266_[i++] = node11;
        }
        if (this.isOpen(node12 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y - 1, p_77267_.z)) && this.hasMalus(node2) && this.hasMalus(node5)) {
            p_77266_[i++] = node12;
        }
        if (this.isOpen(node13 = this.findAcceptedNode(p_77267_.x, p_77267_.y - 1, p_77267_.z - 1)) && this.hasMalus(node3) && this.hasMalus(node5)) {
            p_77266_[i++] = node13;
        }
        if (this.isOpen(node14 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y, p_77267_.z - 1)) && this.hasMalus(node3) && this.hasMalus(node2)) {
            p_77266_[i++] = node14;
        }
        if (this.isOpen(node15 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y, p_77267_.z + 1)) && this.hasMalus(node) && this.hasMalus(node2)) {
            p_77266_[i++] = node15;
        }
        if (this.isOpen(node16 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y, p_77267_.z - 1)) && this.hasMalus(node3) && this.hasMalus(node1)) {
            p_77266_[i++] = node16;
        }
        if (this.isOpen(node17 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y, p_77267_.z + 1)) && this.hasMalus(node) && this.hasMalus(node1)) {
            p_77266_[i++] = node17;
        }
        if (this.isOpen(node18 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y + 1, p_77267_.z - 1)) && this.hasMalus(node14) && this.hasMalus(node3) && this.hasMalus(node2) && this.hasMalus(node4) && this.hasMalus(node9) && this.hasMalus(node8)) {
            p_77266_[i++] = node18;
        }
        if (this.isOpen(node19 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y + 1, p_77267_.z + 1)) && this.hasMalus(node15) && this.hasMalus(node) && this.hasMalus(node2) && this.hasMalus(node4) && this.hasMalus(node6) && this.hasMalus(node8)) {
            p_77266_[i++] = node19;
        }
        if (this.isOpen(node20 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y + 1, p_77267_.z - 1)) && this.hasMalus(node16) && this.hasMalus(node3) && this.hasMalus(node1) && this.hasMalus(node4) && this.hasMalus(node9) && this.hasMalus(node7)) {
            p_77266_[i++] = node20;
        }
        if (this.isOpen(node21 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y + 1, p_77267_.z + 1)) && this.hasMalus(node17) && this.hasMalus(node) && this.hasMalus(node1) && this.hasMalus(node4) && this.hasMalus(node6) && this.hasMalus(node7)) {
            p_77266_[i++] = node21;
        }
        if (this.isOpen(node22 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y - 1, p_77267_.z - 1)) && this.hasMalus(node14) && this.hasMalus(node3) && this.hasMalus(node2) && this.hasMalus(node5) && this.hasMalus(node13) && this.hasMalus(node12)) {
            p_77266_[i++] = node22;
        }
        if (this.isOpen(node23 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y - 1, p_77267_.z + 1)) && this.hasMalus(node15) && this.hasMalus(node) && this.hasMalus(node2) && this.hasMalus(node5) && this.hasMalus(node10) && this.hasMalus(node12)) {
            p_77266_[i++] = node23;
        }
        if (this.isOpen(node24 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y - 1, p_77267_.z - 1)) && this.hasMalus(node16) && this.hasMalus(node3) && this.hasMalus(node1) && this.hasMalus(node5) && this.hasMalus(node13) && this.hasMalus(node11)) {
            p_77266_[i++] = node24;
        }
        if (this.isOpen(node25 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y - 1, p_77267_.z + 1)) && this.hasMalus(node17) && this.hasMalus(node) && this.hasMalus(node1) && this.hasMalus(node5) && this.hasMalus(node10) && this.hasMalus(node11)) {
            p_77266_[i++] = node25;
        }
        return i;
    }

    private boolean hasMalus(@Nullable Node p_77264_) {
        return p_77264_ != null && p_77264_.costMalus >= 0.0f;
    }

    private boolean isOpen(@Nullable Node p_77270_) {
        return p_77270_ != null && !p_77270_.closed;
    }

    @Nullable
    protected Node findAcceptedNode(int p_262970_, int p_263018_, int p_262947_) {
        Node node = null;
        BlockPathTypes blockpathtypes = this.getCachedBlockPathType(p_262970_, p_263018_, p_262947_);
        float f = this.mob.getPathfindingMalus(blockpathtypes);
        if (f >= 0.0f) {
            node = this.getNode(p_262970_, p_263018_, p_262947_);
            node.type = blockpathtypes;
            node.costMalus = Math.max(node.costMalus, f);
            if (blockpathtypes == BlockPathTypes.WALKABLE) {
                node.costMalus += 1.0f;
            }
        }
        return node;
    }

    private BlockPathTypes getCachedBlockPathType(int p_164694_, int p_164695_, int p_164696_) {
        return (BlockPathTypes)this.pathTypeByPosCache.computeIfAbsent(BlockPos.asLong(p_164694_, p_164695_, p_164696_), p_265010_ -> this.getBlockPathType(this.level, p_164694_, p_164695_, p_164696_, this.mob));
    }

    @Override
    public BlockPathTypes getBlockPathType(BlockGetter p_265753_, int p_265243_, int p_265376_, int p_265253_, Mob p_265367_) {
        EnumSet<BlockPathTypes> enumset = EnumSet.noneOf(BlockPathTypes.class);
        BlockPathTypes blockpathtypes = BlockPathTypes.BLOCKED;
        BlockPos blockpos = p_265367_.blockPosition();
        blockpathtypes = super.getBlockPathTypes(p_265753_, p_265243_, p_265376_, p_265253_, enumset, blockpathtypes, blockpos);
        if (enumset.contains(BlockPathTypes.FENCE)) {
            return BlockPathTypes.FENCE;
        }
        BlockPathTypes blockpathtypes1 = BlockPathTypes.BLOCKED;
        for (BlockPathTypes blockpathtypes2 : enumset) {
            if (p_265367_.getPathfindingMalus(blockpathtypes2) < 0.0f) {
                return blockpathtypes2;
            }
            if (!(p_265367_.getPathfindingMalus(blockpathtypes2) >= p_265367_.getPathfindingMalus(blockpathtypes1))) continue;
            blockpathtypes1 = blockpathtypes2;
        }
        return blockpathtypes == BlockPathTypes.OPEN && p_265367_.getPathfindingMalus(blockpathtypes1) == 0.0f ? BlockPathTypes.OPEN : blockpathtypes1;
    }

    @Override
    public BlockPathTypes getBlockPathType(BlockGetter p_77245_, int p_77246_, int p_77247_, int p_77248_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        BlockPathTypes blockpathtypes = FlyNodeEvaluator.getBlockPathTypeRaw(p_77245_, blockpos$mutableblockpos.set(p_77246_, p_77247_, p_77248_));
        if (blockpathtypes == BlockPathTypes.OPEN && p_77247_ >= p_77245_.getMinBuildHeight() + 1) {
            BlockPathTypes blockpathtypes1 = FlyNodeEvaluator.getBlockPathTypeRaw(p_77245_, blockpos$mutableblockpos.set(p_77246_, p_77247_ - 1, p_77248_));
            if (blockpathtypes1 != BlockPathTypes.DAMAGE_FIRE && blockpathtypes1 != BlockPathTypes.LAVA) {
                if (blockpathtypes1 == BlockPathTypes.DAMAGE_OTHER) {
                    blockpathtypes = BlockPathTypes.DAMAGE_OTHER;
                } else if (blockpathtypes1 == BlockPathTypes.COCOA) {
                    blockpathtypes = BlockPathTypes.COCOA;
                } else if (blockpathtypes1 == BlockPathTypes.FENCE) {
                    if (!blockpos$mutableblockpos.equals(this.mob.blockPosition())) {
                        blockpathtypes = BlockPathTypes.FENCE;
                    }
                } else {
                    blockpathtypes = blockpathtypes1 != BlockPathTypes.WALKABLE && blockpathtypes1 != BlockPathTypes.OPEN && blockpathtypes1 != BlockPathTypes.WATER ? BlockPathTypes.WALKABLE : BlockPathTypes.OPEN;
                }
            } else {
                blockpathtypes = BlockPathTypes.DAMAGE_FIRE;
            }
        }
        if (blockpathtypes == BlockPathTypes.WALKABLE || blockpathtypes == BlockPathTypes.OPEN) {
            blockpathtypes = FlyNodeEvaluator.checkNeighbourBlocks(p_77245_, blockpos$mutableblockpos.set(p_77246_, p_77247_, p_77248_), blockpathtypes);
        }
        return blockpathtypes;
    }

    private Iterable<BlockPos> iteratePathfindingStartNodeCandidatePositions(Mob p_263108_) {
        boolean flag;
        float f = 1.0f;
        AABB aabb = p_263108_.getBoundingBox();
        boolean bl = flag = aabb.getSize() < 1.0;
        if (!flag) {
            return List.of(BlockPos.containing(aabb.minX, p_263108_.getBlockY(), aabb.minZ), BlockPos.containing(aabb.minX, p_263108_.getBlockY(), aabb.maxZ), BlockPos.containing(aabb.maxX, p_263108_.getBlockY(), aabb.minZ), BlockPos.containing(aabb.maxX, p_263108_.getBlockY(), aabb.maxZ));
        }
        double d0 = Math.max(0.0, (1.5 - aabb.getZsize()) / 2.0);
        double d1 = Math.max(0.0, (1.5 - aabb.getXsize()) / 2.0);
        double d2 = Math.max(0.0, (1.5 - aabb.getYsize()) / 2.0);
        AABB aabb1 = aabb.inflate(d1, d2, d0);
        return BlockPos.randomBetweenClosed(p_263108_.getRandom(), 10, Mth.floor(aabb1.minX), Mth.floor(aabb1.minY), Mth.floor(aabb1.minZ), Mth.floor(aabb1.maxX), Mth.floor(aabb1.maxY), Mth.floor(aabb1.maxZ));
    }
}

