/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SequentialEntry
extends CompositeEntryBase {
    SequentialEntry(LootPoolEntryContainer[] p_79812_, LootItemCondition[] p_79813_) {
        super(p_79812_, p_79813_);
    }

    @Override
    public LootPoolEntryType getType() {
        return LootPoolEntries.SEQUENCE;
    }

    @Override
    protected ComposableEntryContainer compose(ComposableEntryContainer[] p_79816_) {
        switch (p_79816_.length) {
            case 0: {
                return ALWAYS_TRUE;
            }
            case 1: {
                return p_79816_[0];
            }
            case 2: {
                return p_79816_[0].and(p_79816_[1]);
            }
        }
        return (p_79819_, p_79820_) -> {
            for (ComposableEntryContainer composableentrycontainer : p_79816_) {
                if (composableentrycontainer.expand(p_79819_, p_79820_)) continue;
                return false;
            }
            return true;
        };
    }

    public static Builder sequential(LootPoolEntryContainer.Builder<?> ... p_165153_) {
        return new Builder(p_165153_);
    }

    public static class Builder
    extends LootPoolEntryContainer.Builder<Builder> {
        private final List<LootPoolEntryContainer> entries = Lists.newArrayList();

        public Builder(LootPoolEntryContainer.Builder<?> ... p_165156_) {
            for (LootPoolEntryContainer.Builder<?> builder : p_165156_) {
                this.entries.add(builder.build());
            }
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public Builder then(LootPoolEntryContainer.Builder<?> p_165160_) {
            this.entries.add(p_165160_.build());
            return this;
        }

        @Override
        public LootPoolEntryContainer build() {
            return new SequentialEntry(this.entries.toArray(new LootPoolEntryContainer[0]), this.getConditions());
        }
    }
}

