/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyBlockState
extends LootItemConditionalFunction {
    final Block block;
    final Set<Property<?>> properties;

    CopyBlockState(LootItemCondition[] p_80050_, Block p_80051_, Set<Property<?>> p_80052_) {
        super(p_80050_);
        this.block = p_80051_;
        this.properties = p_80052_;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.COPY_STATE;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParams.BLOCK_STATE);
    }

    @Override
    protected ItemStack run(ItemStack p_80060_, LootContext p_80061_) {
        BlockState blockstate = p_80061_.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (blockstate != null) {
            CompoundTag compoundtag1;
            CompoundTag compoundtag = p_80060_.getOrCreateTag();
            if (compoundtag.contains("BlockStateTag", 10)) {
                compoundtag1 = compoundtag.getCompound("BlockStateTag");
            } else {
                compoundtag1 = new CompoundTag();
                compoundtag.put("BlockStateTag", compoundtag1);
            }
            this.properties.stream().filter(blockstate::hasProperty).forEach(p_80072_ -> compoundtag1.putString(p_80072_.getName(), CopyBlockState.serialize(blockstate, p_80072_)));
        }
        return p_80060_;
    }

    public static Builder copyState(Block p_80063_) {
        return new Builder(p_80063_);
    }

    private static <T extends Comparable<T>> String serialize(BlockState p_80065_, Property<T> p_80066_) {
        T t = p_80065_.getValue(p_80066_);
        return p_80066_.getName(t);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Block block;
        private final Set<Property<?>> properties = Sets.newHashSet();

        Builder(Block p_80079_) {
            this.block = p_80079_;
        }

        public Builder copy(Property<?> p_80085_) {
            if (!this.block.getStateDefinition().getProperties().contains(p_80085_)) {
                throw new IllegalStateException("Property " + String.valueOf(p_80085_) + " is not present on block " + String.valueOf(this.block));
            }
            this.properties.add(p_80085_);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new CopyBlockState(this.getConditions(), this.block, this.properties);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<CopyBlockState> {
        @Override
        public void serialize(JsonObject p_80097_, CopyBlockState p_80098_, JsonSerializationContext p_80099_) {
            super.serialize(p_80097_, p_80098_, p_80099_);
            p_80097_.addProperty("block", BuiltInRegistries.BLOCK.getKey(p_80098_.block).toString());
            JsonArray jsonarray = new JsonArray();
            p_80098_.properties.forEach(p_80091_ -> jsonarray.add(p_80091_.getName()));
            p_80097_.add("properties", (JsonElement)jsonarray);
        }

        @Override
        public CopyBlockState deserialize(JsonObject p_80093_, JsonDeserializationContext p_80094_, LootItemCondition[] p_80095_) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(p_80093_, "block"));
            Block block = (Block)BuiltInRegistries.BLOCK.getOptional(resourcelocation).orElseThrow(() -> new IllegalArgumentException("Can't find block " + String.valueOf(resourcelocation)));
            StateDefinition<Block, BlockState> statedefinition = block.getStateDefinition();
            HashSet set = Sets.newHashSet();
            JsonArray jsonarray = GsonHelper.getAsJsonArray(p_80093_, "properties", null);
            if (jsonarray != null) {
                jsonarray.forEach(p_80111_ -> set.add(statedefinition.getProperty(GsonHelper.convertToString(p_80111_, "property"))));
            }
            return new CopyBlockState(p_80095_, block, set);
        }
    }
}

