/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class EnchantRandomlyFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    final List<Enchantment> enchantments;

    EnchantRandomlyFunction(LootItemCondition[] p_80418_, Collection<Enchantment> p_80419_) {
        super(p_80418_);
        this.enchantments = ImmutableList.copyOf(p_80419_);
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.ENCHANT_RANDOMLY;
    }

    @Override
    public ItemStack run(ItemStack p_80429_, LootContext p_80430_) {
        Enchantment enchantment;
        RandomSource randomsource = p_80430_.getRandom();
        if (this.enchantments.isEmpty()) {
            boolean flag = p_80429_.is(Items.BOOK);
            List list = BuiltInRegistries.ENCHANTMENT.stream().filter(Enchantment::isDiscoverable).filter(p_80436_ -> flag || p_80436_.canEnchant(p_80429_)).collect(Collectors.toList());
            if (list.isEmpty()) {
                LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)p_80429_);
                return p_80429_;
            }
            enchantment = (Enchantment)list.get(randomsource.nextInt(list.size()));
        } else {
            enchantment = this.enchantments.get(randomsource.nextInt(this.enchantments.size()));
        }
        return EnchantRandomlyFunction.enchantItem(p_80429_, enchantment, randomsource);
    }

    private static ItemStack enchantItem(ItemStack p_230980_, Enchantment p_230981_, RandomSource p_230982_) {
        int i = Mth.nextInt(p_230982_, p_230981_.getMinLevel(), p_230981_.getMaxLevel());
        if (p_230980_.is(Items.BOOK)) {
            p_230980_ = new ItemStack(Items.ENCHANTED_BOOK);
            EnchantedBookItem.addEnchantment(p_230980_, new EnchantmentInstance(p_230981_, i));
        } else {
            p_230980_.enchant(p_230981_, i);
        }
        return p_230980_;
    }

    public static Builder randomEnchantment() {
        return new Builder();
    }

    public static LootItemConditionalFunction.Builder<?> randomApplicableEnchantment() {
        return EnchantRandomlyFunction.simpleBuilder(p_80438_ -> new EnchantRandomlyFunction((LootItemCondition[])p_80438_, (Collection<Enchantment>)ImmutableList.of()));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Set<Enchantment> enchantments = Sets.newHashSet();

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder withEnchantment(Enchantment p_80445_) {
            this.enchantments.add(p_80445_);
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new EnchantRandomlyFunction(this.getConditions(), this.enchantments);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<EnchantRandomlyFunction> {
        @Override
        public void serialize(JsonObject p_80454_, EnchantRandomlyFunction p_80455_, JsonSerializationContext p_80456_) {
            super.serialize(p_80454_, p_80455_, p_80456_);
            if (!p_80455_.enchantments.isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (Enchantment enchantment : p_80455_.enchantments) {
                    ResourceLocation resourcelocation = BuiltInRegistries.ENCHANTMENT.getKey(enchantment);
                    if (resourcelocation == null) {
                        throw new IllegalArgumentException("Don't know how to serialize enchantment " + String.valueOf(enchantment));
                    }
                    jsonarray.add((JsonElement)new JsonPrimitive(resourcelocation.toString()));
                }
                p_80454_.add("enchantments", (JsonElement)jsonarray);
            }
        }

        @Override
        public EnchantRandomlyFunction deserialize(JsonObject p_80450_, JsonDeserializationContext p_80451_, LootItemCondition[] p_80452_) {
            ArrayList list = Lists.newArrayList();
            if (p_80450_.has("enchantments")) {
                for (JsonElement jsonelement : GsonHelper.getAsJsonArray(p_80450_, "enchantments")) {
                    String s = GsonHelper.convertToString(jsonelement, "enchantment");
                    Enchantment enchantment = BuiltInRegistries.ENCHANTMENT.getOptional(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown enchantment '" + s + "'"));
                    list.add(enchantment);
                }
            }
            return new EnchantRandomlyFunction(p_80452_, list);
        }
    }
}

