/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.logging.LogUtils;
import java.util.Locale;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class ExplorationMapFunction
extends LootItemConditionalFunction {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final TagKey<Structure> DEFAULT_DESTINATION = StructureTags.ON_TREASURE_MAPS;
    public static final String DEFAULT_DECORATION_NAME = "mansion";
    public static final MapDecoration.Type DEFAULT_DECORATION = MapDecoration.Type.MANSION;
    public static final byte DEFAULT_ZOOM = 2;
    public static final int DEFAULT_SEARCH_RADIUS = 50;
    public static final boolean DEFAULT_SKIP_EXISTING = true;
    final TagKey<Structure> destination;
    final MapDecoration.Type mapDecoration;
    final byte zoom;
    final int searchRadius;
    final boolean skipKnownStructures;

    ExplorationMapFunction(LootItemCondition[] p_210652_, TagKey<Structure> p_210653_, MapDecoration.Type p_210654_, byte p_210655_, int p_210656_, boolean p_210657_) {
        super(p_210652_);
        this.destination = p_210653_;
        this.mapDecoration = p_210654_;
        this.zoom = p_210655_;
        this.searchRadius = p_210656_;
        this.skipKnownStructures = p_210657_;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.EXPLORATION_MAP;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParams.ORIGIN);
    }

    @Override
    public ItemStack run(ItemStack p_80547_, LootContext p_80548_) {
        ServerLevel serverlevel;
        BlockPos blockpos;
        if (!p_80547_.is(Items.MAP)) {
            return p_80547_;
        }
        Vec3 vec3 = p_80548_.getParamOrNull(LootContextParams.ORIGIN);
        if (vec3 != null && (blockpos = (serverlevel = p_80548_.getLevel()).findNearestMapStructure(this.destination, BlockPos.containing(vec3), this.searchRadius, this.skipKnownStructures)) != null) {
            ItemStack itemstack = MapItem.create(serverlevel, blockpos.getX(), blockpos.getZ(), this.zoom, true, true);
            MapItem.renderBiomePreviewMap(serverlevel, itemstack);
            MapItemSavedData.addTargetDecoration(itemstack, blockpos, "+", this.mapDecoration);
            return itemstack;
        }
        return p_80547_;
    }

    public static Builder makeExplorationMap() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private TagKey<Structure> destination = DEFAULT_DESTINATION;
        private MapDecoration.Type mapDecoration = DEFAULT_DECORATION;
        private byte zoom = (byte)2;
        private int searchRadius = 50;
        private boolean skipKnownStructures = true;

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setDestination(TagKey<Structure> p_210659_) {
            this.destination = p_210659_;
            return this;
        }

        public Builder setMapDecoration(MapDecoration.Type p_80574_) {
            this.mapDecoration = p_80574_;
            return this;
        }

        public Builder setZoom(byte p_80570_) {
            this.zoom = p_80570_;
            return this;
        }

        public Builder setSearchRadius(int p_165206_) {
            this.searchRadius = p_165206_;
            return this;
        }

        public Builder setSkipKnownStructures(boolean p_80576_) {
            this.skipKnownStructures = p_80576_;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new ExplorationMapFunction(this.getConditions(), this.destination, this.mapDecoration, this.zoom, this.searchRadius, this.skipKnownStructures);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<ExplorationMapFunction> {
        @Override
        public void serialize(JsonObject p_80587_, ExplorationMapFunction p_80588_, JsonSerializationContext p_80589_) {
            super.serialize(p_80587_, p_80588_, p_80589_);
            if (!p_80588_.destination.equals(DEFAULT_DESTINATION)) {
                p_80587_.addProperty("destination", p_80588_.destination.location().toString());
            }
            if (p_80588_.mapDecoration != DEFAULT_DECORATION) {
                p_80587_.add("decoration", p_80589_.serialize((Object)p_80588_.mapDecoration.toString().toLowerCase(Locale.ROOT)));
            }
            if (p_80588_.zoom != 2) {
                p_80587_.addProperty("zoom", (Number)p_80588_.zoom);
            }
            if (p_80588_.searchRadius != 50) {
                p_80587_.addProperty("search_radius", (Number)p_80588_.searchRadius);
            }
            if (!p_80588_.skipKnownStructures) {
                p_80587_.addProperty("skip_existing_chunks", Boolean.valueOf(p_80588_.skipKnownStructures));
            }
        }

        @Override
        public ExplorationMapFunction deserialize(JsonObject p_80583_, JsonDeserializationContext p_80584_, LootItemCondition[] p_80585_) {
            TagKey<Structure> tagkey = Serializer.readStructure(p_80583_);
            String s = p_80583_.has("decoration") ? GsonHelper.getAsString(p_80583_, "decoration") : ExplorationMapFunction.DEFAULT_DECORATION_NAME;
            MapDecoration.Type mapdecoration$type = DEFAULT_DECORATION;
            try {
                mapdecoration$type = MapDecoration.Type.valueOf(s.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException illegalargumentexception) {
                LOGGER.error("Error while parsing loot table decoration entry. Found {}. Defaulting to {}", (Object)s, (Object)DEFAULT_DECORATION);
            }
            byte b0 = GsonHelper.getAsByte(p_80583_, "zoom", (byte)2);
            int i = GsonHelper.getAsInt(p_80583_, "search_radius", 50);
            boolean flag = GsonHelper.getAsBoolean(p_80583_, "skip_existing_chunks", true);
            return new ExplorationMapFunction(p_80585_, tagkey, mapdecoration$type, b0, i, flag);
        }

        private static TagKey<Structure> readStructure(JsonObject p_210661_) {
            if (p_210661_.has("destination")) {
                String s = GsonHelper.getAsString(p_210661_, "destination");
                return TagKey.create(Registries.STRUCTURE, new ResourceLocation(s));
            }
            return DEFAULT_DESTINATION;
        }
    }
}

