/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.authlib.GameProfile;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class FillPlayerHead
extends LootItemConditionalFunction {
    final LootContext.EntityTarget entityTarget;

    public FillPlayerHead(LootItemCondition[] p_80604_, LootContext.EntityTarget p_80605_) {
        super(p_80604_);
        this.entityTarget = p_80605_;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.FILL_PLAYER_HEAD;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of(this.entityTarget.getParam());
    }

    @Override
    public ItemStack run(ItemStack p_80608_, LootContext p_80609_) {
        Entity entity;
        if (p_80608_.is(Items.PLAYER_HEAD) && (entity = p_80609_.getParamOrNull(this.entityTarget.getParam())) instanceof Player) {
            GameProfile gameprofile = ((Player)entity).getGameProfile();
            p_80608_.getOrCreateTag().put("SkullOwner", NbtUtils.writeGameProfile(new CompoundTag(), gameprofile));
        }
        return p_80608_;
    }

    public static LootItemConditionalFunction.Builder<?> fillPlayerHead(LootContext.EntityTarget p_165208_) {
        return FillPlayerHead.simpleBuilder(p_165211_ -> new FillPlayerHead((LootItemCondition[])p_165211_, p_165208_));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<FillPlayerHead> {
        @Override
        public void serialize(JsonObject p_80619_, FillPlayerHead p_80620_, JsonSerializationContext p_80621_) {
            super.serialize(p_80619_, p_80620_, p_80621_);
            p_80619_.add("entity", p_80621_.serialize((Object)p_80620_.entityTarget));
        }

        @Override
        public FillPlayerHead deserialize(JsonObject p_80615_, JsonDeserializationContext p_80616_, LootItemCondition[] p_80617_) {
            LootContext.EntityTarget lootcontext$entitytarget = GsonHelper.getAsObject(p_80615_, "entity", p_80616_, LootContext.EntityTarget.class);
            return new FillPlayerHead(p_80617_, lootcontext$entitytarget);
        }
    }
}

