/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SetEnchantmentsFunction
extends LootItemConditionalFunction {
    final Map<Enchantment, NumberProvider> enchantments;
    final boolean add;

    SetEnchantmentsFunction(LootItemCondition[] p_165337_, Map<Enchantment, NumberProvider> p_165338_, boolean p_165339_) {
        super(p_165337_);
        this.enchantments = ImmutableMap.copyOf(p_165338_);
        this.add = p_165339_;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_ENCHANTMENTS;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return (Set)this.enchantments.values().stream().flatMap(p_279081_ -> p_279081_.getReferencedContextParams().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ItemStack run(ItemStack p_165346_, LootContext p_165347_) {
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        this.enchantments.forEach((arg_0, arg_1) -> SetEnchantmentsFunction.lambda$run$1((Object2IntMap)object2intmap, p_165347_, arg_0, arg_1));
        if (p_165346_.getItem() == Items.BOOK) {
            ItemStack itemstack = new ItemStack(Items.ENCHANTED_BOOK);
            object2intmap.forEach((p_165343_, p_165344_) -> EnchantedBookItem.addEnchantment(itemstack, new EnchantmentInstance((Enchantment)p_165343_, (int)p_165344_)));
            return itemstack;
        }
        Map<Enchantment, Integer> map = EnchantmentHelper.getEnchantments(p_165346_);
        if (this.add) {
            object2intmap.forEach((p_165366_, p_165367_) -> SetEnchantmentsFunction.updateEnchantment(map, p_165366_, Math.max(map.getOrDefault(p_165366_, 0) + p_165367_, 0)));
        } else {
            object2intmap.forEach((p_165361_, p_165362_) -> SetEnchantmentsFunction.updateEnchantment(map, p_165361_, Math.max(p_165362_, 0)));
        }
        EnchantmentHelper.setEnchantments(map, p_165346_);
        return p_165346_;
    }

    private static void updateEnchantment(Map<Enchantment, Integer> p_165356_, Enchantment p_165357_, int p_165358_) {
        if (p_165358_ == 0) {
            p_165356_.remove(p_165357_);
        } else {
            p_165356_.put(p_165357_, p_165358_);
        }
    }

    private static /* synthetic */ void lambda$run$1(Object2IntMap object2intmap, LootContext p_165347_, Enchantment p_165353_, NumberProvider p_165354_) {
        object2intmap.put((Object)p_165353_, p_165354_.getInt(p_165347_));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetEnchantmentsFunction> {
        @Override
        public void serialize(JsonObject p_165394_, SetEnchantmentsFunction p_165395_, JsonSerializationContext p_165396_) {
            super.serialize(p_165394_, p_165395_, p_165396_);
            JsonObject jsonobject = new JsonObject();
            p_165395_.enchantments.forEach((p_259023_, p_259024_) -> {
                ResourceLocation resourcelocation = BuiltInRegistries.ENCHANTMENT.getKey((Enchantment)p_259023_);
                if (resourcelocation == null) {
                    throw new IllegalArgumentException("Don't know how to serialize enchantment " + String.valueOf(p_259023_));
                }
                jsonobject.add(resourcelocation.toString(), p_165396_.serialize(p_259024_));
            });
            p_165394_.add("enchantments", (JsonElement)jsonobject);
            p_165394_.addProperty("add", Boolean.valueOf(p_165395_.add));
        }

        @Override
        public SetEnchantmentsFunction deserialize(JsonObject p_165381_, JsonDeserializationContext p_165382_, LootItemCondition[] p_165383_) {
            HashMap map = Maps.newHashMap();
            if (p_165381_.has("enchantments")) {
                JsonObject jsonobject = GsonHelper.getAsJsonObject(p_165381_, "enchantments");
                for (Map.Entry entry : jsonobject.entrySet()) {
                    String s = (String)entry.getKey();
                    JsonElement jsonelement = (JsonElement)entry.getValue();
                    Enchantment enchantment = BuiltInRegistries.ENCHANTMENT.getOptional(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown enchantment '" + s + "'"));
                    NumberProvider numberprovider = (NumberProvider)p_165382_.deserialize(jsonelement, NumberProvider.class);
                    map.put(enchantment, numberprovider);
                }
            }
            boolean flag = GsonHelper.getAsBoolean(p_165381_, "add", false);
            return new SetEnchantmentsFunction(p_165383_, map, flag);
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Map<Enchantment, NumberProvider> enchantments = Maps.newHashMap();
        private final boolean add;

        public Builder() {
            this(false);
        }

        public Builder(boolean p_165372_) {
            this.add = p_165372_;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder withEnchantment(Enchantment p_165375_, NumberProvider p_165376_) {
            this.enchantments.put(p_165375_, p_165376_);
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetEnchantmentsFunction(this.getConditions(), this.enchantments, this.add);
        }
    }
}

