/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SetItemCountFunction
extends LootItemConditionalFunction {
    final NumberProvider value;
    final boolean add;

    SetItemCountFunction(LootItemCondition[] p_165409_, NumberProvider p_165410_, boolean p_165411_) {
        super(p_165409_);
        this.value = p_165410_;
        this.add = p_165411_;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_COUNT;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.value.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack p_81006_, LootContext p_81007_) {
        int i = this.add ? p_81006_.getCount() : 0;
        p_81006_.setCount(Mth.clamp(i + this.value.getInt(p_81007_), 0, p_81006_.getMaxStackSize()));
        return p_81006_;
    }

    public static LootItemConditionalFunction.Builder<?> setCount(NumberProvider p_165413_) {
        return SetItemCountFunction.simpleBuilder(p_165423_ -> new SetItemCountFunction((LootItemCondition[])p_165423_, p_165413_, false));
    }

    public static LootItemConditionalFunction.Builder<?> setCount(NumberProvider p_165415_, boolean p_165416_) {
        return SetItemCountFunction.simpleBuilder(p_165420_ -> new SetItemCountFunction((LootItemCondition[])p_165420_, p_165415_, p_165416_));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetItemCountFunction> {
        @Override
        public void serialize(JsonObject p_81026_, SetItemCountFunction p_81027_, JsonSerializationContext p_81028_) {
            super.serialize(p_81026_, p_81027_, p_81028_);
            p_81026_.add("count", p_81028_.serialize((Object)p_81027_.value));
            p_81026_.addProperty("add", Boolean.valueOf(p_81027_.add));
        }

        @Override
        public SetItemCountFunction deserialize(JsonObject p_81018_, JsonDeserializationContext p_81019_, LootItemCondition[] p_81020_) {
            NumberProvider numberprovider = GsonHelper.getAsObject(p_81018_, "count", p_81019_, NumberProvider.class);
            boolean flag = GsonHelper.getAsBoolean(p_81018_, "add", false);
            return new SetItemCountFunction(p_81020_, numberprovider, flag);
        }
    }
}

