/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class BonusLevelTableCondition
implements LootItemCondition {
    final Enchantment enchantment;
    final float[] values;

    BonusLevelTableCondition(Enchantment p_81510_, float[] p_81511_) {
        this.enchantment = p_81510_;
        this.values = p_81511_;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.TABLE_BONUS;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParams.TOOL);
    }

    @Override
    public boolean test(LootContext p_81521_) {
        ItemStack itemstack = p_81521_.getParamOrNull(LootContextParams.TOOL);
        int i = itemstack != null ? EnchantmentHelper.getItemEnchantmentLevel(this.enchantment, itemstack) : 0;
        float f = this.values[Math.min(i, this.values.length - 1)];
        return p_81521_.getRandom().nextFloat() < f;
    }

    public static LootItemCondition.Builder bonusLevelFlatChance(Enchantment p_81518_, float ... p_81519_) {
        return () -> new BonusLevelTableCondition(p_81518_, p_81519_);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<BonusLevelTableCondition> {
        @Override
        public void serialize(JsonObject p_81537_, BonusLevelTableCondition p_81538_, JsonSerializationContext p_81539_) {
            p_81537_.addProperty("enchantment", BuiltInRegistries.ENCHANTMENT.getKey(p_81538_.enchantment).toString());
            p_81537_.add("chances", p_81539_.serialize((Object)p_81538_.values));
        }

        @Override
        public BonusLevelTableCondition deserialize(JsonObject p_81547_, JsonDeserializationContext p_81548_) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(p_81547_, "enchantment"));
            Enchantment enchantment = BuiltInRegistries.ENCHANTMENT.getOptional(resourcelocation).orElseThrow(() -> new JsonParseException("Invalid enchantment id: " + String.valueOf(resourcelocation)));
            float[] afloat = GsonHelper.getAsObject(p_81547_, "chances", p_81548_, float[].class);
            return new BonusLevelTableCondition(enchantment, afloat);
        }
    }
}

