/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.timers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.primitives.UnsignedLong;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.timers.TimerCallback;
import net.minecraft.world.level.timers.TimerCallbacks;
import org.slf4j.Logger;

public class TimerQueue<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CALLBACK_DATA_TAG = "Callback";
    private static final String TIMER_NAME_TAG = "Name";
    private static final String TIMER_TRIGGER_TIME_TAG = "TriggerTime";
    private final TimerCallbacks<T> callbacksRegistry;
    private final Queue<Event<T>> queue = new PriorityQueue<Event<T>>(TimerQueue.createComparator());
    private UnsignedLong sequentialId = UnsignedLong.ZERO;
    private final Table<String, Long, Event<T>> events = HashBasedTable.create();

    private static <T> Comparator<Event<T>> createComparator() {
        return Comparator.comparingLong(p_82272_ -> p_82272_.triggerTime).thenComparing(p_82269_ -> p_82269_.sequentialId);
    }

    public TimerQueue(TimerCallbacks<T> p_82249_, Stream<? extends Dynamic<?>> p_82250_) {
        this(p_82249_);
        this.queue.clear();
        this.events.clear();
        this.sequentialId = UnsignedLong.ZERO;
        p_82250_.forEach(p_265027_ -> {
            Tag tag = (Tag)p_265027_.convert((DynamicOps)NbtOps.INSTANCE).getValue();
            if (tag instanceof CompoundTag) {
                CompoundTag compoundtag = (CompoundTag)tag;
                this.loadEvent(compoundtag);
            } else {
                LOGGER.warn("Invalid format of events: {}", (Object)tag);
            }
        });
    }

    public TimerQueue(TimerCallbacks<T> p_82247_) {
        this.callbacksRegistry = p_82247_;
    }

    public void tick(T p_82257_, long p_82258_) {
        Event<T> event;
        while ((event = this.queue.peek()) != null && event.triggerTime <= p_82258_) {
            this.queue.remove();
            this.events.remove((Object)event.id, (Object)p_82258_);
            event.callback.handle(p_82257_, this, p_82258_);
        }
        return;
    }

    public void schedule(String p_82262_, long p_82263_, TimerCallback<T> p_82264_) {
        if (!this.events.contains((Object)p_82262_, (Object)p_82263_)) {
            this.sequentialId = this.sequentialId.plus(UnsignedLong.ONE);
            Event<T> event = new Event<T>(p_82263_, this.sequentialId, p_82262_, p_82264_);
            this.events.put((Object)p_82262_, (Object)p_82263_, event);
            this.queue.add(event);
        }
    }

    public int remove(String p_82260_) {
        Collection collection = this.events.row((Object)p_82260_).values();
        collection.forEach(this.queue::remove);
        int i = collection.size();
        collection.clear();
        return i;
    }

    public Set<String> getEventsIds() {
        return Collections.unmodifiableSet(this.events.rowKeySet());
    }

    private void loadEvent(CompoundTag p_82266_) {
        CompoundTag compoundtag = p_82266_.getCompound(CALLBACK_DATA_TAG);
        TimerCallback<T> timercallback = this.callbacksRegistry.deserialize(compoundtag);
        if (timercallback != null) {
            String s = p_82266_.getString(TIMER_NAME_TAG);
            long i = p_82266_.getLong(TIMER_TRIGGER_TIME_TAG);
            this.schedule(s, i, timercallback);
        }
    }

    private CompoundTag storeEvent(Event<T> p_82255_) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putString(TIMER_NAME_TAG, p_82255_.id);
        compoundtag.putLong(TIMER_TRIGGER_TIME_TAG, p_82255_.triggerTime);
        compoundtag.put(CALLBACK_DATA_TAG, this.callbacksRegistry.serialize(p_82255_.callback));
        return compoundtag;
    }

    public ListTag store() {
        ListTag listtag = new ListTag();
        this.queue.stream().sorted(TimerQueue.createComparator()).map(this::storeEvent).forEach(listtag::add);
        return listtag;
    }

    public static class Event<T> {
        public final long triggerTime;
        public final UnsignedLong sequentialId;
        public final String id;
        public final TimerCallback<T> callback;

        Event(long p_82278_, UnsignedLong p_82279_, String p_82280_, TimerCallback<T> p_82281_) {
            this.triggerTime = p_82278_;
            this.sequentialId = p_82279_;
            this.id = p_82280_;
            this.callback = p_82281_;
        }
    }
}

