/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.FileNotFoundException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.obj.ObjMaterialLibrary;
import net.minecraftforge.client.model.obj.ObjModel;
import net.minecraftforge.client.model.obj.ObjTokenizer;

public class ObjLoader
implements IGeometryLoader<ObjModel>,
ResourceManagerReloadListener {
    public static ObjLoader INSTANCE = new ObjLoader();
    private final Map<ObjModel.ModelSettings, ObjModel> modelCache = Maps.newConcurrentMap();
    private final Map<ResourceLocation, ObjMaterialLibrary> materialCache = Maps.newConcurrentMap();
    private ResourceManager manager = Minecraft.getInstance().getResourceManager();

    @Override
    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.modelCache.clear();
        this.materialCache.clear();
        this.manager = resourceManager;
    }

    @Override
    public ObjModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
        if (!jsonObject.has("model")) {
            throw new JsonParseException("OBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        String modelLocation = jsonObject.get("model").getAsString();
        boolean automaticCulling = GsonHelper.getAsBoolean(jsonObject, "automatic_culling", true);
        boolean shadeQuads = GsonHelper.getAsBoolean(jsonObject, "shade_quads", true);
        boolean flipV = GsonHelper.getAsBoolean(jsonObject, "flip_v", false);
        boolean emissiveAmbient = GsonHelper.getAsBoolean(jsonObject, "emissive_ambient", true);
        String mtlOverride = GsonHelper.getAsString(jsonObject, "mtl_override", null);
        return this.loadModel(new ObjModel.ModelSettings(new ResourceLocation(modelLocation), automaticCulling, shadeQuads, flipV, emissiveAmbient, mtlOverride));
    }

    public ObjModel loadModel(ObjModel.ModelSettings settings) {
        return this.modelCache.computeIfAbsent(settings, data -> {
            ObjModel objModel;
            Resource resource = this.manager.getResource(settings.modelLocation()).orElseThrow();
            ObjTokenizer tokenizer = new ObjTokenizer(resource.open());
            try {
                objModel = ObjModel.parse(tokenizer, settings);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        tokenizer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ model", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ model", e);
                }
            }
            tokenizer.close();
            return objModel;
        });
    }

    public ObjMaterialLibrary loadMaterialLibrary(ResourceLocation materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            ObjMaterialLibrary objMaterialLibrary;
            Resource resource = this.manager.getResource((ResourceLocation)location).orElseThrow();
            ObjTokenizer rdr = new ObjTokenizer(resource.open());
            try {
                objMaterialLibrary = new ObjMaterialLibrary(rdr);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        rdr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ material library", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ material library", e);
                }
            }
            rdr.close();
            return objMaterialLibrary;
        });
    }
}

