/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items.wrapper;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;

public class PlayerMainInvWrapper
extends RangedWrapper {
    private final Inventory inventoryPlayer;

    public PlayerMainInvWrapper(Inventory inv) {
        super(new InvWrapper(inv), 0, inv.items.size());
        this.inventoryPlayer = inv;
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack inSlot;
        ItemStack rest = super.insertItem(slot, stack, simulate);
        if (rest.getCount() != stack.getCount() && !(inSlot = this.getStackInSlot(slot)).isEmpty()) {
            if (this.getInventoryPlayer().player.level().isClientSide) {
                inSlot.setPopTime(5);
            } else if (this.getInventoryPlayer().player instanceof ServerPlayer) {
                this.getInventoryPlayer().player.containerMenu.broadcastChanges();
            }
        }
        return rest;
    }

    public Inventory getInventoryPlayer() {
        return this.inventoryPlayer;
    }
}

