/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class InteractivePanelManager {
    private JPanel mainPanel;
    private JTableHeader header;
    private TableColumnModel columnModel;
    private int separatorWidth;

    public InteractivePanelManager() {
        JTable table = new JTable();
        this.header = table.getTableHeader();
        this.columnModel = this.header.getColumnModel();
        this.separatorWidth = new JSeparator((int)1).getPreferredSize().width;
        this.mainPanel = new JPanel(new HeaderLayoutManager());
        this.columnModel.addColumnModelListener(new PanelManagerColumnModelListener());
    }

    public void setHeaderFont(Font font) {
        this.header.setFont(font);
    }

    public void addComponent(String name, JComponent component) {
        TableColumn column = new TableColumn();
        column.addPropertyChangeListener(e -> this.columnPropertyChanged(e));
        column.setHeaderValue(new ComponentData(name, component));
        column.setPreferredWidth(component.getPreferredSize().width + this.separatorWidth);
        column.setWidth(component.getPreferredSize().width);
        this.columnModel.addColumn(column);
        this.mainPanel.add(component);
        this.mainPanel.add(new JSeparator(1));
    }

    public List<JComponent> getComponents() {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            TableColumn column = this.columnModel.getColumn(i);
            components.add(((ComponentData)column.getHeaderValue()).component);
        }
        return components;
    }

    public void setName(JComponent component, String newName) {
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            TableColumn column = this.columnModel.getColumn(i);
            ComponentData componentData = (ComponentData)column.getHeaderValue();
            if (componentData.component() != component) continue;
            column.setHeaderValue(new ComponentData(newName, component));
            break;
        }
    }

    public void removeComponent(JComponent component) {
        int i;
        int componentCount = this.mainPanel.getComponentCount();
        for (i = 0; i < componentCount; ++i) {
            if (this.mainPanel.getComponent(i) != component) continue;
            this.mainPanel.remove(i);
            this.mainPanel.remove(i);
            break;
        }
        for (i = 0; i < this.columnModel.getColumnCount(); ++i) {
            TableColumn column = this.columnModel.getColumn(i);
            if (((ComponentData)column.getHeaderValue()).component != component) continue;
            this.columnModel.removeColumn(column);
            break;
        }
    }

    public JComponent getMainPanel() {
        return this.mainPanel;
    }

    public JComponent getColumnHeader() {
        return this.header;
    }

    public int getColumnWidth(String viewName) {
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            TableColumn column = this.columnModel.getColumn(i);
            ComponentData data = (ComponentData)column.getHeaderValue();
            if (!data.name().equals(viewName)) continue;
            return column.getWidth();
        }
        return 0;
    }

    public void setColumnWidth(String viewName, int width) {
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            TableColumn column = this.columnModel.getColumn(i);
            ComponentData data = (ComponentData)column.getHeaderValue();
            if (!data.name().equals(viewName)) continue;
            column.setWidth(width);
            return;
        }
    }

    public void resetColumnWidthToPreferredWidth(String viewName) {
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            TableColumn column = this.columnModel.getColumn(i);
            ComponentData data = (ComponentData)column.getHeaderValue();
            if (!data.name().equals(viewName)) continue;
            column.setWidth(data.component().getPreferredSize().width);
            return;
        }
    }

    private void columnPropertyChanged(PropertyChangeEvent e) {
        if ("width".equals(e.getPropertyName())) {
            TableColumn column = (TableColumn)e.getSource();
            column.setPreferredWidth((Integer)e.getNewValue());
            this.update();
        }
    }

    private void update() {
        this.mainPanel.invalidate();
        Container parent = this.mainPanel.getParent();
        if (parent != null) {
            parent.validate();
            parent.repaint();
        }
    }

    private class HeaderLayoutManager
    implements LayoutManager {
        private HeaderLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            int n = parent.getComponentCount();
            int height = 0;
            int width = InteractivePanelManager.this.columnModel.getTotalColumnWidth();
            for (int i = 0; i < n; ++i) {
                Component c = parent.getComponent(i);
                Dimension d = c.getPreferredSize();
                height = Math.max(height, d.height);
            }
            return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            int n = parent.getComponentCount();
            Dimension d = parent.getSize();
            Insets insets = parent.getInsets();
            int height = d.height - insets.top - insets.bottom;
            int x = insets.left;
            int y = insets.top;
            for (int i = 0; i < n; ++i) {
                if (i % 2 == 0) {
                    TableColumn column = InteractivePanelManager.this.columnModel.getColumn(i / 2);
                    ComponentData componentData = (ComponentData)column.getHeaderValue();
                    JComponent c = componentData.component();
                    int width = column.getWidth() - InteractivePanelManager.this.separatorWidth;
                    c.setBounds(x, y, width, height);
                    x += width;
                    continue;
                }
                Component c = parent.getComponent(i);
                d = c.getPreferredSize();
                c.setBounds(x, y, d.width, height);
                x += d.width;
            }
        }
    }

    private class PanelManagerColumnModelListener
    implements TableColumnModelListener {
        private PanelManagerColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            InteractivePanelManager.this.update();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            InteractivePanelManager.this.update();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            InteractivePanelManager.this.update();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    record ComponentData(String name, JComponent component) {
        @Override
        public String toString() {
            return this.name;
        }
    }
}

