/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.windows;

import ghidra.pty.windows.HandleInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;

public class AnsiBufferedInputStream
extends InputStream {
    private static final Charset WINDOWS_1252 = Charset.forName("windows-1252");
    private final InputStream in;
    private int countIn = 0;
    private ByteBuffer lineBaked = ByteBuffer.allocate(Short.MAX_VALUE);
    private ByteBuffer lineBuf = ByteBuffer.allocate(Short.MAX_VALUE);
    private ByteBuffer escBuf = ByteBuffer.allocate(1024);
    private ByteBuffer titleBuf = ByteBuffer.allocate(255);
    private Mode mode = Mode.CHARS;

    public AnsiBufferedInputStream(InputStream in) {
        if (in instanceof HandleInputStream) {
            in = new BufferedInputStream(in);
        }
        this.in = in;
        this.lineBuf.limit(0);
        this.lineBaked.limit(0);
    }

    @Override
    public int read() throws IOException {
        if (this.lineBaked.hasRemaining()) {
            return this.lineBaked.get();
        }
        if (this.readUntilBaked() < 0) {
            return -1;
        }
        if (this.lineBaked.hasRemaining()) {
            return this.lineBaked.get();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.lineBaked.hasRemaining() && this.readUntilBaked() < 0) {
            return -1;
        }
        int read = Math.min(this.lineBaked.remaining(), len);
        this.lineBaked.get(b, off, read);
        return read;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        super.close();
    }

    protected int readUntilBaked() throws IOException {
        while (!this.lineBaked.hasRemaining() && this.processNext() >= 0) {
        }
        if (!this.lineBaked.hasRemaining()) {
            return -1;
        }
        return this.lineBaked.remaining();
    }

    protected void printDebugChar(byte c) {
        if (32 <= c && c <= 127) {
            System.err.print(new String(new byte[]{c}));
        } else {
            System.err.print(String.format("<%02x>", c & 0xFF));
        }
    }

    protected int processNext() throws IOException {
        int ci = this.in.read();
        if (ci == -1) {
            return -1;
        }
        byte c = (byte)ci;
        switch (this.mode.ordinal()) {
            case 0: {
                this.processChars(c);
                break;
            }
            case 1: {
                this.processEsc(c);
                break;
            }
            case 2: {
                this.processCsi(c);
                break;
            }
            case 3: {
                this.processCsiParamOrCommand(c);
                break;
            }
            case 4: {
                this.processCsiQ(c);
                break;
            }
            case 5: {
                this.processOsc(c);
                break;
            }
            case 6: {
                this.processWindowTitle(c);
                break;
            }
            case 7: {
                this.processWindowTitleEsc(c);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        ++this.countIn;
        return c;
    }

    protected int guessEnd() {
        for (int i = this.lineBuf.limit() - 1; i >= 0; --i) {
            byte c = this.lineBuf.get(i);
            if (c == 32 || c == 0) continue;
            return i + 1;
        }
        return 0;
    }

    protected void bakeLine() {
        this.lineBuf.position(0);
        this.lineBuf.limit(this.guessEnd() + 1);
        this.lineBuf.put(this.lineBuf.limit() - 1, (byte)10);
        ByteBuffer temp = this.lineBaked;
        this.lineBaked = this.lineBuf;
        this.lineBuf = temp;
        this.lineBuf.clear();
        Arrays.fill(this.lineBuf.array(), (byte)0);
        this.lineBuf.limit(0);
    }

    protected void appendChar(byte c) {
        int limit = this.lineBuf.limit();
        if (this.lineBuf.position() == limit) {
            this.lineBuf.limit(limit + 1);
        }
        this.lineBuf.put(c);
    }

    protected void processChars(byte c) {
        switch (c) {
            case 8: {
                if (this.lineBuf.get(this.lineBuf.position() - 1) != 32) break;
                this.lineBuf.position(this.lineBuf.position() - 1);
                break;
            }
            case 10: {
                this.bakeLine();
                break;
            }
            case 27: {
                this.mode = Mode.ESC;
                break;
            }
            default: {
                this.appendChar(c);
            }
        }
    }

    protected void processEsc(byte c) {
        switch (c) {
            case 91: {
                this.mode = Mode.CSI;
                break;
            }
            case 93: {
                this.mode = Mode.OSC;
                break;
            }
            default: {
                throw new AssertionError((Object)("Saw 'ESC " + c + "' at " + this.countIn));
            }
        }
    }

    protected void processCsi(byte c) {
        switch (c) {
            default: {
                this.processCsiParamOrCommand(c);
                break;
            }
            case 63: {
                this.mode = Mode.CSI_Q;
            }
        }
    }

    protected void processCsiParamOrCommand(byte c) {
        switch (c) {
            default: {
                this.escBuf.put(c);
                break;
            }
            case 65: {
                this.execCursorUp();
                this.mode = Mode.CHARS;
                break;
            }
            case 66: {
                this.execCursorDown();
                this.mode = Mode.CHARS;
                break;
            }
            case 67: {
                this.execCursorForward();
                this.mode = Mode.CHARS;
                break;
            }
            case 68: {
                this.execCursorBackward();
                this.mode = Mode.CHARS;
                break;
            }
            case 71: {
                this.execCursorCharAbsolute();
                this.mode = Mode.CHARS;
                break;
            }
            case 72: {
                this.execCursorPosition();
                this.mode = Mode.CHARS;
                break;
            }
            case 74: {
                this.execEraseInDisplay();
                this.mode = Mode.CHARS;
                break;
            }
            case 75: {
                this.execEraseInLine();
                this.mode = Mode.CHARS;
                break;
            }
            case 88: {
                this.execEraseCharacter();
                this.mode = Mode.CHARS;
                break;
            }
            case 109: {
                this.execSetGraphicsRendition();
                this.mode = Mode.CHARS;
                break;
            }
            case 104: {
                this.execPrivateSequence(true);
                this.mode = Mode.CHARS;
                break;
            }
            case 108: {
                this.execPrivateSequence(false);
                this.mode = Mode.CHARS;
            }
        }
    }

    protected void processCsiQ(byte c) {
        switch (c) {
            default: {
                this.escBuf.put(c);
                break;
            }
            case 104: {
                String buf = this.readAndClearEscBuf();
                if ("12".equals(buf)) {
                    this.execTextCursorEnableBlinking();
                    this.escBuf.clear();
                    this.mode = Mode.CHARS;
                    break;
                }
                if ("25".equals(buf)) {
                    this.execTextCursorEnableModeShow();
                    this.escBuf.clear();
                    this.mode = Mode.CHARS;
                    break;
                }
                throw new AssertionError();
            }
            case 108: {
                String buf = this.readAndClearEscBuf();
                if ("12".equals(buf)) {
                    this.execTextCursorDisableBlinking();
                    this.escBuf.clear();
                    this.mode = Mode.CHARS;
                    break;
                }
                if (!"25".equals(buf)) break;
                this.execTextCursorDisableModeShow();
                this.escBuf.clear();
                this.mode = Mode.CHARS;
            }
        }
    }

    protected void processOsc(byte c) {
        switch (c) {
            default: {
                this.escBuf.put(c);
                break;
            }
            case 59: {
                if (Set.of("0", "2").contains(this.readAndClearEscBuf())) {
                    this.mode = Mode.WINDOW_TITLE;
                    this.escBuf.clear();
                    break;
                }
                throw new AssertionError();
            }
        }
    }

    protected void processWindowTitle(byte c) {
        switch (c) {
            default: {
                this.titleBuf.put(c);
                break;
            }
            case 7: {
                this.execSetWindowTitle();
                this.mode = Mode.CHARS;
                break;
            }
            case 27: {
                this.mode = Mode.WINDOW_TITLE_ESC;
            }
        }
    }

    protected void processWindowTitleEsc(byte c) {
        switch (c) {
            case 92: {
                this.execSetWindowTitle();
                this.mode = Mode.CHARS;
                break;
            }
            default: {
                throw new AssertionError((Object)("Saw <ST> ... ESC " + c + " at " + this.countIn));
            }
        }
    }

    protected String readAndClear(ByteBuffer buf) {
        buf.flip();
        String result = new String(buf.array(), buf.position(), buf.remaining(), WINDOWS_1252);
        buf.clear();
        return result;
    }

    protected String readAndClearEscBuf() {
        return this.readAndClear(this.escBuf);
    }

    protected int parseNumericBuffer() {
        String numeric = this.readAndClearEscBuf();
        if (numeric.isEmpty()) {
            return 0;
        }
        int result = Integer.parseInt(numeric);
        return result;
    }

    protected int[] parseNumericListBuffer() {
        String numericList = this.readAndClearEscBuf();
        if (numericList.isEmpty()) {
            return new int[0];
        }
        return Stream.of(numericList.split(";")).mapToInt(Integer::parseInt).toArray();
    }

    protected void execCursorUp() {
        throw new UnsupportedOperationException("Cursor Up");
    }

    protected void execCursorDown() {
        throw new UnsupportedOperationException("Cursor Down");
    }

    protected void setPosition(int newPosition) {
        if (this.lineBuf.limit() < newPosition) {
            this.lineBuf.limit(newPosition);
        }
        this.lineBuf.position(newPosition);
    }

    protected void execCursorForward() {
        int delta = this.parseNumericBuffer();
        this.setPosition(this.lineBuf.position() + delta);
    }

    protected void execCursorBackward() {
        int delta = this.parseNumericBuffer();
        this.lineBuf.position(this.lineBuf.position() - delta);
    }

    protected void execCursorCharAbsolute() {
        int abs = this.parseNumericBuffer();
        this.lineBuf.position(abs - 1);
    }

    protected void execCursorPosition() {
        int[] yx = this.parseNumericListBuffer();
        if (yx.length == 0) {
            this.lineBuf.position(0);
            return;
        }
        if (yx.length != 2) {
            throw new AssertionError();
        }
        if (yx[0] != 1) {
            throw new AssertionError();
        }
        this.lineBuf.position(yx[1] - 1);
    }

    protected void execTextCursorEnableBlinking() {
    }

    protected void execTextCursorDisableBlinking() {
    }

    protected void execTextCursorEnableModeShow() {
    }

    protected void execTextCursorDisableModeShow() {
    }

    protected void execEraseInDisplay() {
        this.execEraseInLine();
    }

    protected void execEraseInLine() {
        switch (this.parseNumericBuffer()) {
            case 0: {
                Arrays.fill(this.lineBuf.array(), this.lineBuf.position(), this.lineBuf.capacity(), (byte)0);
                break;
            }
            case 1: {
                Arrays.fill(this.lineBuf.array(), 0, this.lineBuf.position() + 1, (byte)0);
                break;
            }
            case 2: {
                Arrays.fill(this.lineBuf.array(), (byte)0);
            }
        }
    }

    protected void execEraseCharacter() {
        int count = this.parseNumericBuffer();
        Arrays.fill(this.lineBuf.array(), this.lineBuf.position(), this.lineBuf.position() + count, (byte)32);
    }

    protected void execSetGraphicsRendition() {
        this.escBuf.clear();
    }

    protected void execSetWindowTitle() {
        this.titleBuf.clear();
    }

    protected void execPrivateSequence(boolean enable) {
        this.escBuf.clear();
    }

    private static enum Mode {
        CHARS,
        ESC,
        CSI,
        CSI_p,
        CSI_Q,
        OSC,
        WINDOW_TITLE,
        WINDOW_TITLE_ESC;

    }
}

