/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results;

import docking.DialogComponentProvider;
import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.gui.search.dialog.BSimFilterPanel;
import ghidra.features.bsim.gui.search.dialog.BSimFilterSet;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class BSimSearchResultsFilterDialog
extends DialogComponentProvider {
    private BSimFilterPanel filterPanel;
    private boolean cancelled = false;

    protected BSimSearchResultsFilterDialog(List<BSimFilterType> filters, BSimFilterSet filterSet) {
        super("BSim Results Filters");
        this.setTransient(this.isTransient());
        this.addWorkPanel(this.buildMainPanel(filters, filterSet));
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation("BSimSearchPlugin", "BSim_Filters"));
    }

    private JComponent buildMainPanel(List<BSimFilterType> filters, BSimFilterSet filterSet) {
        this.filterPanel = new BSimFilterPanel(filters, filterSet, this::filterValueChanged);
        this.filterPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.filterPanel.setPreferredSize(new Dimension(700, 200));
        return this.filterPanel;
    }

    private void filterValueChanged() {
        if (this.filterPanel.hasValidFilters()) {
            this.setOkEnabled(true);
            this.clearStatusText();
        } else {
            this.setOkEnabled(false);
            this.setStatusText("One or more filters has invalid data!", MessageType.ERROR);
        }
    }

    public BSimFilterSet getFilters() {
        if (this.cancelled) {
            return null;
        }
        return this.filterPanel.getFilterSet();
    }

    protected void cancelCallback() {
        this.cancelled = true;
        this.close();
    }

    protected void okCallback() {
        if (!this.filterPanel.hasValidFilters()) {
            this.setStatusText("One or more filters is invalid!", MessageType.ERROR);
            return;
        }
        this.close();
    }
}

