/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.util.LinkedList;
import java.util.TreeMap;

public class PriorityQueue<T> {
    private int size = 0;
    private TreeMap<Integer, LinkedList<T>> tree = new TreeMap();

    public void add(T obj, int priority) {
        Integer key = priority;
        LinkedList<Object> list = this.tree.get(key);
        if (list == null) {
            list = new LinkedList();
            this.tree.put(key, list);
        }
        list.addLast(obj);
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public T getFirst() {
        if (this.tree.isEmpty()) {
            return null;
        }
        Integer key = this.tree.firstKey();
        LinkedList<T> list = this.tree.get(key);
        return list.getFirst();
    }

    public Integer getFirstPriority() {
        if (this.tree.isEmpty()) {
            return null;
        }
        Integer key = this.tree.firstKey();
        return key;
    }

    public T getLast() {
        if (this.tree.isEmpty()) {
            return null;
        }
        Integer key = this.tree.lastKey();
        LinkedList<T> list = this.tree.get(key);
        return list.getLast();
    }

    public Integer getLastPriority() {
        if (this.tree.isEmpty()) {
            return null;
        }
        Integer key = this.tree.lastKey();
        return key;
    }

    public T removeFirst() {
        if (this.tree.isEmpty()) {
            return null;
        }
        --this.size;
        Integer key = this.tree.firstKey();
        LinkedList<T> list = this.tree.get(key);
        if (list.size() == 1) {
            this.tree.remove(key);
        }
        return list.removeFirst();
    }

    public T removeLast() {
        if (this.tree.isEmpty()) {
            return null;
        }
        --this.size;
        Integer key = this.tree.lastKey();
        LinkedList<T> list = this.tree.get(key);
        if (list.size() == 1) {
            this.tree.remove(key);
        }
        return list.removeLast();
    }

    public void clear() {
        this.size = 0;
        this.tree.clear();
    }
}

