/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.reloc;

import db.DBFieldIterator;
import db.DBHandle;
import db.DBRecord;
import db.KeyToRecordIterator;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.reloc.RelocationDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.reloc.Relocation;
import ghidra.util.exception.VersionException;
import java.io.IOException;

public class RelocationDBAdapterV5
extends RelocationDBAdapter {
    static final int VERSION = 5;
    static final int V5_ADDR_COL = 0;
    static final int V5_TYPE_COL = 1;
    static final int V5_VALUE_COL = 2;
    static final int V5_BYTES_COL = 3;
    static final int V5_SYMBOL_NAME_COL = 4;
    private Table relocTable;
    private AddressMap addrMap;

    RelocationDBAdapterV5(DBHandle handle, AddressMap addrMap) throws IOException, VersionException {
        this.addrMap = addrMap;
        this.relocTable = handle.getTable("Relocations");
        if (this.relocTable == null || this.relocTable.getSchema().getVersion() != 5) {
            throw new VersionException();
        }
    }

    @Override
    void add(Address addr, byte flags, int type, long[] values, byte[] bytes, String symbolName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    int getRecordCount() {
        return this.relocTable.getRecordCount();
    }

    @Override
    RecordIterator iterator() throws IOException {
        KeyToRecordIterator recIter = new KeyToRecordIterator(this.relocTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.relocTable, 0, this.addrMap, true));
        return new RelocationDBAdapter.RecordIteratorAdapter(this, (RecordIterator)recIter);
    }

    @Override
    RecordIterator iterator(AddressSetView set) throws IOException {
        KeyToRecordIterator recIter = new KeyToRecordIterator(this.relocTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.relocTable, 0, this.addrMap, set, true));
        return new RelocationDBAdapter.RecordIteratorAdapter(this, (RecordIterator)recIter);
    }

    @Override
    RecordIterator iterator(Address start) throws IOException {
        KeyToRecordIterator recIter = new KeyToRecordIterator(this.relocTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.relocTable, 0, this.addrMap, start, true));
        return new RelocationDBAdapter.RecordIteratorAdapter(this, (RecordIterator)recIter);
    }

    @Override
    DBRecord adaptRecord(DBRecord rec) {
        if (rec == null) {
            return null;
        }
        DBRecord newRec = SCHEMA.createRecord(rec.getKey());
        newRec.setLongValue(0, rec.getLongValue(0));
        newRec.setByteValue(1, RelocationDBAdapterV5.getFlags(Relocation.Status.UNKNOWN, 0));
        newRec.setIntValue(2, rec.getIntValue(1));
        newRec.setBinaryData(3, rec.getBinaryData(2));
        newRec.setBinaryData(4, rec.getBinaryData(3));
        newRec.setString(5, rec.getString(4));
        return newRec;
    }
}

