/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.pdb.classtype.VFTable;
import ghidra.app.util.pdb.classtype.VFTableEntry;
import ghidra.app.util.pdb.classtype.VirtualFunctionTableEntry;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.gclass.ClassID;
import ghidra.program.model.gclass.ClassUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class VirtualFunctionTable
implements VFTable {
    protected ClassID owner;
    protected List<ClassID> parentage;
    protected int userSpecifiedNumEntries;
    protected Long ptrOffsetInClass;
    protected int maxTableIndexSeen;
    protected Map<Integer, VirtualFunctionTableEntry> entriesByTableIndex;
    private Structure tableStructure;
    private boolean isBuilt;

    VirtualFunctionTable(ClassID owner, List<ClassID> parentage) {
        this.owner = owner;
        this.parentage = new ArrayList<ClassID>(parentage);
        this.userSpecifiedNumEntries = 0;
        this.maxTableIndexSeen = -1;
        this.entriesByTableIndex = new TreeMap<Integer, VirtualFunctionTableEntry>();
    }

    public abstract Address getAddress(int var1) throws PdbException;

    public ClassID getOwner() {
        return this.owner;
    }

    public List<ClassID> getParentage() {
        return this.parentage;
    }

    public Long getPtrOffsetInClass() {
        return this.ptrOffsetInClass;
    }

    protected abstract VirtualFunctionTableEntry getNewEntry(SymbolPath var1, SymbolPath var2, Pointer var3);

    public void addEntry(int tableIndex, SymbolPath originalMethodPath, SymbolPath overrideMethodPath, Pointer functionPointer) {
        VirtualFunctionTableEntry entry = this.getNewEntry(originalMethodPath, overrideMethodPath, functionPointer);
        this.entriesByTableIndex.put(tableIndex, entry);
        this.maxTableIndexSeen = Integer.max(this.maxTableIndexSeen, tableIndex);
    }

    public VirtualFunctionTableEntry getEntry(int tableIndex) {
        return this.entriesByTableIndex.get(tableIndex);
    }

    public int getNumEntries() {
        return this.entriesByTableIndex.size();
    }

    public int getUserSpecifiedNumEntries() {
        return this.userSpecifiedNumEntries;
    }

    public void setOwner(ClassID ownerArg) {
        this.owner = ownerArg;
    }

    public void setParentage(List<ClassID> parentage) {
        this.parentage = parentage;
    }

    public void setPtrOffsetInClass(Long offset) {
        this.ptrOffsetInClass = offset;
    }

    public void setNumEntries(int numEntriesArg) {
        this.userSpecifiedNumEntries = numEntriesArg;
    }

    void emit(StringBuilder builder) {
        builder.append("VBT for the following classes within: " + String.valueOf(this.owner));
        builder.append("\n");
        for (ClassID id : this.parentage) {
            builder.append("   " + String.valueOf(id));
            builder.append("\n");
        }
    }

    public int size() {
        return this.entriesByTableIndex.size();
    }

    public int getMaxTableIndex() {
        return this.maxTableIndexSeen;
    }

    public Map<Integer, VirtualFunctionTableEntry> getEntriesByTableIndex() {
        return this.entriesByTableIndex;
    }

    public Structure createDataType(DataTypeManager dtm, CategoryPath categoryPath) {
        if (!this.isBuilt) {
            this.build(dtm, categoryPath);
        }
        return this.tableStructure;
    }

    private void build(DataTypeManager dtm, CategoryPath categoryPath) {
        if (this.ptrOffsetInClass == null || this.maxTableIndexSeen == -1) {
            this.tableStructure = null;
            this.isBuilt = true;
            return;
        }
        String name = ClassUtils.getSpecialVxTableName((long)this.ptrOffsetInClass);
        DataType defaultEntry = ClassUtils.getVftDefaultEntry((DataTypeManager)dtm);
        int entrySize = defaultEntry.getLength();
        StructureDataType dt = new StructureDataType(categoryPath, name, 0, dtm);
        int masterOffset = 0;
        for (Map.Entry<Integer, VirtualFunctionTableEntry> mapEntry : this.entriesByTableIndex.entrySet()) {
            int tableIndex = mapEntry.getKey();
            VFTableEntry tableEntry = mapEntry.getValue();
            while (masterOffset < tableIndex) {
                dt.add(defaultEntry, "", "");
                masterOffset += entrySize;
            }
            dt.add((DataType)tableEntry.getFunctionPointer(), tableEntry.getOverridePath().toString(), "");
            masterOffset += entrySize;
        }
        dt.align(defaultEntry.getAlignedLength());
        dt.setToDefaultPacking();
        this.tableStructure = (Structure)dtm.resolve((DataType)dt, null);
        this.isBuilt = true;
    }
}

