/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.func;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ISF.AbstractIsfObject;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Parameter;
import java.util.ArrayList;
import java.util.List;
import sarif.export.func.ExtDataType;

public class ExtFunctionParam
extends AbstractIsfObject {
    String comment;
    int ordinal;
    int size;
    String typeName;
    String typeLocation;
    ExtDataType type;
    String formalTypeName;
    String formalTypeLocation;
    ExtDataType formalType;
    boolean isAutoParameter;
    boolean isForcedIndirect;
    List<String> registers;
    int stackOffset;

    public ExtFunctionParam(Parameter p) {
        super(p.getDataType());
        this.name = p.getName();
        this.ordinal = p.getOrdinal();
        this.size = p.getLength();
        this.comment = p.getComment();
        this.isAutoParameter = p.isAutoParameter();
        this.isForcedIndirect = p.isForcedIndirect();
        DataType dataType = p.getDataType();
        this.typeName = dataType.getName();
        this.typeLocation = dataType.getCategoryPath().getPath();
        this.type = new ExtDataType(dataType);
        dataType = p.getFormalDataType();
        this.formalTypeName = dataType.getName();
        this.formalTypeLocation = dataType.getCategoryPath().getPath();
        this.formalType = new ExtDataType(dataType);
        List regs = p.getRegisters();
        if (regs != null) {
            this.registers = new ArrayList<String>();
            for (Register r : regs) {
                this.registers.add(r.getName());
            }
        }
        try {
            this.stackOffset = p.getStackOffset();
        }
        catch (UnsupportedOperationException uoe) {
            this.stackOffset = -1;
        }
    }
}

